/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;

public class PagingExample {
    public static void main(String[] args) throws Exception {
        PagingExample.simplePaging();
        PagingExample.pageFullLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pageFullLimit() throws Exception {
        try (InitialContext initialContext = null;){
            initialContext = new InitialContext();
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            Connection connection = cf.createConnection();
            try {
                Session session = connection.createSession(true, 0);
                Queue queue = session.createQueue("pagingQueueLimited");
                MessageProducer pageMessageProducer = session.createProducer((Destination)queue);
                pageMessageProducer.setDeliveryMode(2);
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(new byte[10240]);
                try {
                    for (int i = 0; i < 2000; ++i) {
                        pageMessageProducer.send((Message)message);
                        if (i <= 0 || i % 100 != 0) continue;
                        session.commit();
                    }
                    throw new RuntimeException("Example was supposed to get a page full exception. Check your example configuration or report a bug");
                }
                catch (JMSException e) {
                    System.out.println("The producer has thrown an expected exception " + e);
                    session.commit();
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simplePaging() throws Exception {
        try (InitialContext initialContext = null;){
            initialContext = new InitialContext();
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            Queue pageQueue = (Queue)initialContext.lookup("queue/pagingQueue");
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            try (Connection connection = cf.createConnection();){
                int i;
                Session session = connection.createSession(false, 2);
                MessageProducer pageMessageProducer = session.createProducer((Destination)pageQueue);
                pageMessageProducer.setDeliveryMode(1);
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(new byte[10240]);
                for (int i2 = 0; i2 < 20; ++i2) {
                    pageMessageProducer.send((Message)message);
                }
                MessageProducer messageProducer = session.createProducer((Destination)queue);
                messageProducer.setDeliveryMode(1);
                for (int i3 = 0; i3 < 1000; ++i3) {
                    messageProducer.send((Message)message);
                }
                MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                connection.start();
                for (i = 0; i < 1000; ++i) {
                    message = (BytesMessage)messageConsumer.receive(3000L);
                    if (i % 100 != 0) continue;
                    System.out.println("Received " + i + " messages");
                    message.acknowledge();
                }
                message.acknowledge();
                messageConsumer.close();
                messageConsumer = session.createConsumer((Destination)pageQueue);
                for (i = 0; i < 20; ++i) {
                    message = (BytesMessage)messageConsumer.receive(1000L);
                    System.out.println("Received message " + i + " from pageQueue");
                    message.acknowledge();
                }
            }
        }
    }
}

