/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.example.SimpleMessageListener;

public class MessagePriorityExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AtomicBoolean result = new AtomicBoolean(true);
        ArrayList<TextMessage> msgReceived = new ArrayList<TextMessage>();
        try (Connection connection = null;){
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage[] sentMessages = new TextMessage[]{session.createTextMessage("first message"), session.createTextMessage("second message"), session.createTextMessage("third message")};
            producer.send((Message)sentMessages[0]);
            System.out.println("Message sent: " + sentMessages[0].getText() + " with priority: " + sentMessages[0].getJMSPriority());
            producer.send((Message)sentMessages[1], 1, 5, 0L);
            System.out.println("Message sent: " + sentMessages[1].getText() + "with priority: " + sentMessages[1].getJMSPriority());
            producer.send((Message)sentMessages[2], 1, 9, 0L);
            System.out.println("Message sent: " + sentMessages[2].getText() + "with priority: " + sentMessages[2].getJMSPriority());
            MessageConsumer redConsumer = session.createConsumer((Destination)queue);
            redConsumer.setMessageListener((MessageListener)new SimpleMessageListener(msgReceived, result));
            connection.start();
            Thread.sleep(5000L);
            for (int i = 0; i < 3; ++i) {
                TextMessage rm = msgReceived.get(i);
                if (rm.getText().equals(sentMessages[2 - i].getText())) continue;
                throw new IllegalStateException("Priority is broken!");
            }
            if (!result.get()) {
                throw new IllegalStateException();
            }
        }
    }
}

