/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.example.SimpleMessageListener;

public class MessageGroup2Example {
    private boolean result = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ConcurrentHashMap<String, String> messageReceiverMap = new ConcurrentHashMap<String, String>();
        try (Connection connection = null;){
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616?groupID=Group-0");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer1 = session.createProducer((Destination)queue);
            MessageProducer producer2 = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            consumer1.setMessageListener((MessageListener)new SimpleMessageListener("consumer-1", messageReceiverMap));
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            consumer2.setMessageListener((MessageListener)new SimpleMessageListener("consumer-2", messageReceiverMap));
            int msgCount = 10;
            for (int i = 0; i < msgCount; ++i) {
                TextMessage m = session.createTextMessage("producer1 message " + i);
                producer1.send((Message)m);
                System.out.println("Sent message: " + m.getText());
                TextMessage m2 = session.createTextMessage("producer2 message " + i);
                producer2.send((Message)m2);
                System.out.println("Sent message: " + m2.getText());
            }
            System.out.println("all messages are sent");
            connection.start();
            Thread.sleep(2000L);
            String trueReceiver = (String)messageReceiverMap.get("producer1 message 0");
            for (int i = 0; i < msgCount; ++i) {
                String receiver = (String)messageReceiverMap.get("producer1 message " + i);
                if (!trueReceiver.equals(receiver)) {
                    throw new IllegalStateException("Group message [producer1 message " + i + "] went to wrong receiver: " + receiver);
                }
                receiver = (String)messageReceiverMap.get("producer2 message " + i);
                if (trueReceiver.equals(receiver)) continue;
                throw new IllegalStateException("Group message [producer2 message " + i + "] went to wrong receiver: " + receiver);
            }
        }
    }
}

