/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.example.SimpleMessageListener;

public class MessageGroupExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ConcurrentHashMap<String, String> messageReceiverMap = new ConcurrentHashMap<String, String>();
        try (Connection connection = null;){
            Queue queue = ActiveMQJMSClient.createQueue((String)"queue/exampleQueue");
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            consumer1.setMessageListener((MessageListener)new SimpleMessageListener("consumer-1", messageReceiverMap));
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            consumer2.setMessageListener((MessageListener)new SimpleMessageListener("consumer-2", messageReceiverMap));
            int msgCount = 10;
            TextMessage[] groupMessages = new TextMessage[msgCount];
            for (int i = 0; i < msgCount; ++i) {
                groupMessages[i] = session.createTextMessage("Group-0 message " + i);
                groupMessages[i].setStringProperty("JMSXGroupID", "Group-0");
                producer.send((Message)groupMessages[i]);
                System.out.println("Sent message: " + groupMessages[i].getText());
            }
            System.out.println("all messages are sent");
            connection.start();
            Thread.sleep(2000L);
            String trueReceiver = (String)messageReceiverMap.get(groupMessages[0].getText());
            for (TextMessage grpMsg : groupMessages) {
                String receiver = (String)messageReceiverMap.get(grpMsg.getText());
                if (trueReceiver.equals(receiver)) continue;
                throw new IllegalStateException("Group message [" + grpMsg.getText() + "[ went to wrong receiver: " + receiver);
            }
            cf.close();
        }
    }
}

