/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.management.MessageCounterInfo;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.jms.management.JMSQueueControl;

public class MessageCounterExample {
    private static final String JMX_URL = "service:jmx:rmi:///jndi/rmi://localhost:3001/jmxrmi";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        QueueConnection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            QueueConnectionFactory cf = (QueueConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createQueueConnection();
            QueueSession session = connection.createQueueSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            System.out.println("Sent message: " + message.getText());
            System.out.println("Sleep a little bit to have the queue sampled...");
            Thread.sleep(3000L);
            ObjectName on = ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(queue.getQueueName());
            JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(JMX_URL), new HashMap());
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            JMSQueueControl queueControl = MBeanServerInvocationHandler.newProxyInstance(mbsc, on, JMSQueueControl.class, false);
            String counters = queueControl.listMessageCounter();
            MessageCounterInfo messageCounter = MessageCounterInfo.fromJSON((String)counters);
            MessageCounterExample.displayMessageCounter(messageCounter);
            System.out.println("Sleep a little bit again...");
            Thread.sleep(3000L);
            counters = queueControl.listMessageCounter();
            messageCounter = MessageCounterInfo.fromJSON((String)counters);
            MessageCounterExample.displayMessageCounter(messageCounter);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)consumer.receive(5000L);
            System.out.format("Received message: %s%n%n", messageReceived.getText());
            System.out.println("Sleep a little bit one last time...");
            Thread.sleep(3000L);
            counters = queueControl.listMessageCounter();
            messageCounter = MessageCounterInfo.fromJSON((String)counters);
            MessageCounterExample.displayMessageCounter(messageCounter);
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void displayMessageCounter(MessageCounterInfo counter) {
        System.out.format("%s (sample updated at %s)%n", counter.getName(), counter.getUdpateTimestamp());
        System.out.format("   %s message(s) added to the queue (since last sample: %s)%n", counter.getCount(), counter.getCountDelta());
        System.out.format("   %s message(s) in the queue (since last sample: %s)%n", counter.getDepth(), counter.getDepthDelta());
        System.out.format("   last message added at %s%n%n", counter.getLastAddTimestamp());
    }
}

