/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class LastValueQueueExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (Connection connection = null;){
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("1st message with Last-Value property set");
            message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
            producer.send((Message)message);
            System.out.format("Sent message: %s%n", message.getText());
            message = session.createTextMessage("2nd message with Last-Value property set");
            message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
            producer.send((Message)message);
            System.out.format("Sent message: %s%n", message.getText());
            message = session.createTextMessage("3rd message with Last-Value property set");
            message.setStringProperty("_AMQ_LVQ_NAME", "STOCK_NAME");
            producer.send((Message)message);
            System.out.format("Sent message: %s%n", message.getText());
            try (QueueBrowser browser = session.createBrowser(queue);){
                Enumeration enumeration = browser.getEnumeration();
                while (enumeration.hasMoreElements()) {
                    TextMessage messageInTheQueue = (TextMessage)enumeration.nextElement();
                    System.out.format("Message in the queue: %s%n", messageInTheQueue.getText());
                }
            }
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.format("Received message: %s%n", messageReceived.getText());
            messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.format("Received message: %s%n", messageReceived);
            cf.close();
        }
    }
}

