/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class DurableSubscriptionExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Topic topic = (Topic)initialContext.lookup("topic/exampleTopic");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            connection.setClientID("durable-client");
            connection.start();
            Session session = connection.createSession(false, 1);
            MessageProducer messageProducer = session.createProducer((Destination)topic);
            TopicSubscriber subscriber = session.createDurableSubscriber(topic, "subscriber-1");
            TextMessage message1 = session.createTextMessage("This is a text message 1");
            messageProducer.send((Message)message1);
            System.out.println("Sent message: " + message1.getText());
            TextMessage messageReceived = (TextMessage)subscriber.receive();
            System.out.println("Received message: " + messageReceived.getText());
            TextMessage message2 = session.createTextMessage("This is a text message 2");
            messageProducer.send((Message)message2);
            System.out.println("Sent message: " + message2.getText());
            subscriber.close();
            subscriber = session.createDurableSubscriber(topic, "subscriber-1");
            messageReceived = (TextMessage)subscriber.receive();
            System.out.println("Received message: " + messageReceived.getText());
            subscriber.close();
            session.unsubscribe("subscriber-1");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }
}

