/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.qpid.jms.JmsConnectionFactory;

public class BrokerPluginExample {
    public static void main(String[] args) throws Exception {
        BrokerPluginExample.sendConsumeAMQP();
        BrokerPluginExample.sendConsumeCore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendConsumeAMQP() throws JMSException {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory("amqp://localhost:5672");
        try (Connection connection = null;){
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("exampleQueue");
            MessageProducer sender = session.createProducer((Destination)queue);
            sender.send((Message)session.createTextMessage("Hello world "));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TextMessage m = (TextMessage)consumer.receive(5000L);
            if (m.getStringProperty("count") == null) {
                throw new RuntimeException("missed property count");
            }
            System.out.println("message = " + m.getText() + " property count (added by interceptor = " + m.getStringProperty("count") + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendConsumeCore() throws JMSException {
        try (Connection connection = null;){
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616");
            ActiveMQQueue queue = new ActiveMQQueue("exampleQueue");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            if (messageReceived.getStringProperty("count") == null) {
                throw new RuntimeException("missed property count");
            }
            System.out.println("message = " + messageReceived.getText() + " property count (added by interceptor = " + messageReceived.getStringProperty("count") + ")");
        }
    }
}

