/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.qpid.jms.JmsConnectionFactory;

public class DisasterAndRecovery {
    public static void main(String[] args) throws Exception {
        TextMessage message;
        MessageConsumer consumer;
        int i;
        Queue queue;
        Session session;
        JmsConnectionFactory cfServer0 = new JmsConnectionFactory("amqp://localhost:5660");
        JmsConnectionFactory cfServer1 = new JmsConnectionFactory("amqp://localhost:5661");
        try (Connection connection = cfServer0.createConnection();){
            session = connection.createSession(false, 1);
            queue = session.createQueue("exampleQueue");
            MessageProducer producer = session.createProducer((Destination)queue);
            for (i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("Message " + i));
            }
        }
        connection = cfServer1.createConnection();
        try {
            session = connection.createSession(false, 1);
            queue = session.createQueue("exampleQueue");
            connection.start();
            consumer = session.createConsumer((Destination)queue);
            for (i = 0; i < 50; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                System.out.println("Received Message on server1: " + message.getText());
                if (message.getText().equals("Message " + i)) continue;
                throw new IllegalStateException("Mirror Example is not working as expected");
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Thread.sleep(1000L);
        connection = cfServer0.createConnection();
        try {
            session = connection.createSession(false, 1);
            queue = session.createQueue("exampleQueue");
            connection.start();
            consumer = session.createConsumer((Destination)queue);
            for (i = 50; i < 100; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                System.out.println("Received Message on the original server0: " + message.getText());
                if (message.getText().equals("Message " + i)) continue;
                throw new IllegalStateException("Mirror Example is not working as expected");
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

