/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ProtonCPPExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            JmsConnectionFactory cf = new JmsConnectionFactory("amqp://localhost:61616");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("exampleQueue");
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            MessageProducer producerAnswer = session.createProducer((Destination)queue);
            connection.start();
            System.out.println("On a shell script, execute the following:");
            System.out.println("./compile.sh");
            System.out.println("./hello");
            for (int i = 0; i < 10; ++i) {
                try {
                    TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
                    if (messageReceived == null) {
                        System.out.println("No messages");
                        continue;
                    }
                    System.out.println("message received: " + messageReceived.getText());
                    producerAnswer.send((Message)session.createTextMessage("HELLO from Apache ActiveMQ Artemis " + i + "!!"));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

