/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;

public class ProtonCPPExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            MessageProducer producerAnswer = session.createProducer((Destination)queue);
            connection.start();
            System.out.println("On a shell script, execute the following:");
            System.out.println("./compile.sh");
            System.out.println("./hello");
            Message messageReceived = messageConsumer.receive(5000L);
            if (messageReceived == null) {
            } else {
                System.out.println("message received: " + messageReceived);
                producerAnswer.send((Message)session.createTextMessage("HELLO from Apache ActiveMQ Artemis"));
            }
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private int getMessageCount(Connection connection) throws Exception {
        QueueSession session = ((QueueConnection)connection).createQueueSession(false, 1);
        Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
        QueueRequestor requestor = new QueueRequestor(session, managementQueue);
        connection.start();
        Message m = session.createMessage();
        JMSManagementHelper.putAttribute((Message)m, (String)"jms.queue.exampleQueue", (String)"messageCount");
        Message response = requestor.request(m);
        int messageCount = (Integer)JMSManagementHelper.getResult((Message)response);
        return messageCount;
    }
}

