package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import org.apache.activemq.artemis.core.server.MessageReference;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-06-14T15:48:58-0400")
public class MQTTLogger_$logger extends DelegatingBasicLogger implements MQTTLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MQTTLogger_$logger.class.getName();
    public MQTTLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToSendMessage(final MessageReference message, final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToSendMessage$str(), message);
    }
    protected String unableToSendMessage$str() {
        return "AMQ832000: Unable to send message: {0}";
    }
    @Override
    public final void failedToAckMessage(final String clientId, final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToAckMessage$str(), clientId);
    }
    protected String failedToAckMessage$str() {
        return "AMQ832001: MQTT client({0}) attempted to ack already ack'd message: ";
    }
    @Override
    public final void errorRemovingSubscription(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorRemovingSubscription$str());
    }
    protected String errorRemovingSubscription$str() {
        return "AMQ834000: Error removing subscription.";
    }
    @Override
    public final void errorDisconnectingClient(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorDisconnectingClient$str());
    }
    protected String errorDisconnectingClient$str() {
        return "AMQ834001: Error disconnecting client.";
    }
    @Override
    public final void errorProcessingControlPacket(final String packet, final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorProcessingControlPacket$str(), packet);
    }
    protected String errorProcessingControlPacket$str() {
        return "AMQ834002: Error processing control packet: {0}";
    }
    @Override
    public final void errorSendingWillMessage(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorSendingWillMessage$str());
    }
    protected String errorSendingWillMessage$str() {
        return "AMQ834003: Error sending will message.";
    }
    @Override
    public final void errorDisconnectingConsumer(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorDisconnectingConsumer$str());
    }
    protected String errorDisconnectingConsumer$str() {
        return "AMQ834004: Error disconnecting consumer.";
    }
    @Override
    public final void failedToCastProperty(final String property) {
        super.log.logv(FQCN, ERROR, null, failedToCastProperty$str(), property);
    }
    protected String failedToCastProperty$str() {
        return "AMQ834005: Failed to cast property {0}.";
    }
    @Override
    public final void failedToPublishMqttMessage(final String exceptionMessage, final Throwable t) {
        super.log.logv(FQCN, ERROR, t, failedToPublishMqttMessage$str(), exceptionMessage);
    }
    protected String failedToPublishMqttMessage$str() {
        return "AMQ834006: Failed to publish MQTT message: {0}.";
    }
}
