/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public class MQTTSessionCallback
implements SessionCallback {
    private final MQTTSession session;
    private final MQTTConnection connection;
    private MQTTLogger log = MQTTLogger.LOGGER;

    public MQTTSessionCallback(MQTTSession session, MQTTConnection connection) throws Exception {
        this.session = session;
        this.connection = connection;
    }

    public boolean isWritable(ReadyListener callback) {
        return this.connection.isWritable(callback);
    }

    public int sendMessage(MessageReference reference, ServerMessage message, ServerConsumer consumer, int deliveryCount) {
        try {
            this.session.getMqttPublishManager().sendMessage(message, consumer, deliveryCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.warn("Unable to send message: " + message.getMessageID() + " Cause: " + e.getMessage());
        }
        return 1;
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        return false;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        this.log.warn("Sending LARGE MESSAGE");
        return 1;
    }

    public int sendLargeMessage(MessageReference reference, ServerMessage message, ServerConsumer consumer, long bodySize, int deliveryCount) {
        return this.sendMessage(reference, message, consumer, deliveryCount);
    }

    public void disconnect(ServerConsumer consumer, String queueName) {
        try {
            consumer.removeItself();
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }

    public void afterDelivery() throws Exception {
    }

    public void browserFinished(ServerConsumer consumer) {
    }

    public boolean hasCredits(ServerConsumer consumerID) {
        return true;
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public void closed() {
    }
}

