/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolHandler;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

class MQTTProtocolManager
extends AbstractProtocolManager<MqttMessage, MQTTInterceptor, MQTTConnection>
implements NotificationListener {
    private static final List<String> websocketRegistryNames = Arrays.asList("mqtt", "mqttv3.1");
    private ActiveMQServer server;
    private MQTTLogger log = MQTTLogger.LOGGER;
    private final List<MQTTInterceptor> incomingInterceptors = new ArrayList<MQTTInterceptor>();
    private final List<MQTTInterceptor> outgoingInterceptors = new ArrayList<MQTTInterceptor>();

    MQTTProtocolManager(ActiveMQServer server, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
        this.server = server;
        this.updateInterceptors(incomingInterceptors, outgoingInterceptors);
    }

    public void onNotification(Notification notification) {
    }

    public ProtocolManagerFactory getFactory() {
        return new MQTTProtocolManagerFactory();
    }

    public void updateInterceptors(List incoming, List outgoing) {
        this.incomingInterceptors.clear();
        this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        this.outgoingInterceptors.clear();
        this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        try {
            MQTTConnection mqttConnection = new MQTTConnection(connection);
            ConnectionEntry entry = new ConnectionEntry((RemotingConnection)mqttConnection, null, System.currentTimeMillis(), 5000L);
            NettyServerConnection nettyConnection = (NettyServerConnection)connection;
            MQTTProtocolHandler protocolHandler = (MQTTProtocolHandler)nettyConnection.getChannel().pipeline().get(MQTTProtocolHandler.class);
            protocolHandler.setConnection(mqttConnection, entry);
            return entry;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        connection.bufferReceived(connection.getID(), buffer);
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new MqttEncoder()});
        pipeline.addLast(new ChannelHandler[]{new MqttDecoder(0xFFFFFFF)});
        pipeline.addLast(new ChannelHandler[]{new MQTTProtocolHandler(this.server, this)});
    }

    public boolean isProtocol(byte[] array) {
        boolean mqtt311 = array[4] == 77 && array[5] == 81 && array[6] == 84 && array[7] == 84;
        boolean mqtt31 = array[4] == 77 && array[5] == 81 && array[6] == 73 && array[7] == 115;
        return mqtt311 || mqtt31;
    }

    public MessageConverter getConverter() {
        return null;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    public void invokeIncoming(MqttMessage mqttMessage, MQTTConnection connection) {
        super.invokeInterceptors(this.incomingInterceptors, (Object)mqttMessage, (RemotingConnection)connection);
    }

    public void invokeOutgoing(MqttMessage mqttMessage, MQTTConnection connection) {
        super.invokeInterceptors(this.outgoingInterceptors, (Object)mqttMessage, (RemotingConnection)connection);
    }
}

