/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.junit.EmbeddedActiveMQDelegate;
import org.apache.activemq.artemis.junit.EmbeddedActiveMQOperations;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedActiveMQResource
extends ExternalResource
implements EmbeddedActiveMQOperations {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private EmbeddedActiveMQOperations embeddedActiveMQDelegate;

    public EmbeddedActiveMQResource() {
        this.embeddedActiveMQDelegate = new EmbeddedActiveMQDelegate();
    }

    public EmbeddedActiveMQResource(int serverId) {
        this.embeddedActiveMQDelegate = new EmbeddedActiveMQDelegate(serverId);
    }

    public EmbeddedActiveMQResource(Configuration configuration) {
        this.embeddedActiveMQDelegate = new EmbeddedActiveMQDelegate(configuration);
    }

    public EmbeddedActiveMQResource(String filename) {
        this.embeddedActiveMQDelegate = new EmbeddedActiveMQDelegate(filename);
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        EmbeddedActiveMQDelegate.addMessageProperties((ClientMessage)message, properties);
    }

    public void start() {
        this.embeddedActiveMQDelegate.start();
    }

    public void stop() {
        this.embeddedActiveMQDelegate.stop();
    }

    protected void before() throws Throwable {
        logger.info("Starting {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.embeddedActiveMQDelegate.getServerName());
        this.embeddedActiveMQDelegate.start();
        super.before();
    }

    protected void after() {
        logger.info("Stopping {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.embeddedActiveMQDelegate.getServerName());
        this.embeddedActiveMQDelegate.stop();
        super.after();
    }

    public boolean isUseDurableMessage() {
        return this.embeddedActiveMQDelegate.isUseDurableMessage();
    }

    public void setUseDurableMessage(boolean useDurableMessage) {
        this.embeddedActiveMQDelegate.setUseDurableMessage(useDurableMessage);
    }

    public boolean isUseDurableQueue() {
        return this.embeddedActiveMQDelegate.isUseDurableQueue();
    }

    public void setUseDurableQueue(boolean useDurableQueue) {
        this.embeddedActiveMQDelegate.setUseDurableQueue(useDurableQueue);
    }

    public long getDefaultReceiveTimeout() {
        return this.embeddedActiveMQDelegate.getDefaultReceiveTimeout();
    }

    public void setDefaultReceiveTimeout(long defaultReceiveTimeout) {
        this.embeddedActiveMQDelegate.setDefaultReceiveTimeout(defaultReceiveTimeout);
    }

    public EmbeddedActiveMQ getServer() {
        return this.embeddedActiveMQDelegate.getServer();
    }

    public String getServerName() {
        return this.embeddedActiveMQDelegate.getServerName();
    }

    public String getVmURL() {
        return this.embeddedActiveMQDelegate.getVmURL();
    }

    public long getMessageCount(String queueName) {
        return this.embeddedActiveMQDelegate.getMessageCount(queueName);
    }

    public long getMessageCount(SimpleString queueName) {
        return this.embeddedActiveMQDelegate.getMessageCount(queueName);
    }

    public Queue locateQueue(String queueName) {
        return this.embeddedActiveMQDelegate.locateQueue(queueName);
    }

    public Queue locateQueue(SimpleString queueName) {
        return this.embeddedActiveMQDelegate.locateQueue(queueName);
    }

    public List<Queue> getBoundQueues(String address) {
        return this.embeddedActiveMQDelegate.getBoundQueues(address);
    }

    public List<Queue> getBoundQueues(SimpleString address) {
        return this.embeddedActiveMQDelegate.getBoundQueues(address);
    }

    public Queue createQueue(String name) {
        return this.embeddedActiveMQDelegate.createQueue(name);
    }

    public Queue createQueue(String address, String name) {
        return this.embeddedActiveMQDelegate.createQueue(address, name);
    }

    public Queue createQueue(SimpleString address, SimpleString name) {
        return this.embeddedActiveMQDelegate.createQueue(address, name);
    }

    public void createSharedQueue(String name, String user) {
        this.embeddedActiveMQDelegate.createSharedQueue(name, user);
    }

    public void createSharedQueue(String address, String name, String user) {
        this.embeddedActiveMQDelegate.createSharedQueue(address, name, user);
    }

    public void createSharedQueue(SimpleString address, SimpleString name, SimpleString user) {
        this.embeddedActiveMQDelegate.createSharedQueue(address, name, user);
    }

    public ClientMessage createMessage() {
        return this.embeddedActiveMQDelegate.createMessage();
    }

    public ClientMessage createMessage(byte[] body) {
        return this.embeddedActiveMQDelegate.createMessage(body);
    }

    public ClientMessage createMessage(String body) {
        return this.embeddedActiveMQDelegate.createMessage(body);
    }

    public ClientMessage createMessageWithProperties(Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.createMessageWithProperties(properties);
    }

    public ClientMessage createMessageWithProperties(byte[] body, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.createMessageWithProperties(body, properties);
    }

    public ClientMessage createMessageWithProperties(String body, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.createMessageWithProperties(body, properties);
    }

    public void sendMessage(String address, ClientMessage message) {
        this.embeddedActiveMQDelegate.sendMessage(address, message);
    }

    public ClientMessage sendMessage(String address, byte[] body) {
        return this.embeddedActiveMQDelegate.sendMessage(address, body);
    }

    public ClientMessage sendMessage(String address, String body) {
        return this.embeddedActiveMQDelegate.sendMessage(address, body);
    }

    public ClientMessage sendMessageWithProperties(String address, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.sendMessageWithProperties(address, properties);
    }

    public ClientMessage sendMessageWithProperties(String address, byte[] body, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.sendMessageWithProperties(address, body, properties);
    }

    public ClientMessage sendMessageWithProperties(String address, String body, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.sendMessageWithProperties(address, body, properties);
    }

    public void sendMessage(SimpleString address, ClientMessage message) {
        this.embeddedActiveMQDelegate.sendMessage(address, message);
    }

    public ClientMessage sendMessage(SimpleString address, byte[] body) {
        return this.embeddedActiveMQDelegate.sendMessage(address, body);
    }

    public ClientMessage sendMessage(SimpleString address, String body) {
        return this.embeddedActiveMQDelegate.sendMessage(address, body);
    }

    public ClientMessage sendMessageWithProperties(SimpleString address, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.sendMessageWithProperties(address, properties);
    }

    public ClientMessage sendMessageWithProperties(SimpleString address, byte[] body, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.sendMessageWithProperties(address, body, properties);
    }

    public ClientMessage sendMessageWithProperties(SimpleString address, String body, Map<String, Object> properties) {
        return this.embeddedActiveMQDelegate.sendMessageWithProperties(address, body, properties);
    }

    public ClientMessage receiveMessage(String queueName) {
        return this.embeddedActiveMQDelegate.receiveMessage(queueName);
    }

    public ClientMessage receiveMessage(String queueName, long timeout) {
        return this.embeddedActiveMQDelegate.receiveMessage(queueName, timeout);
    }

    public ClientMessage receiveMessage(SimpleString queueName) {
        return this.embeddedActiveMQDelegate.receiveMessage(queueName);
    }

    public ClientMessage receiveMessage(SimpleString queueName, long timeout) {
        return this.embeddedActiveMQDelegate.receiveMessage(queueName, timeout);
    }

    public ClientMessage browseMessage(String queueName) {
        return this.embeddedActiveMQDelegate.browseMessage(queueName);
    }

    public ClientMessage browseMessage(String queueName, long timeout) {
        return this.embeddedActiveMQDelegate.browseMessage(queueName, timeout);
    }

    public ClientMessage browseMessage(SimpleString queueName) {
        return this.embeddedActiveMQDelegate.browseMessage(queueName);
    }

    public ClientMessage browseMessage(SimpleString queueName, long timeout) {
        return this.embeddedActiveMQDelegate.browseMessage(queueName, timeout);
    }
}

