/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypedPropertiesTest {
    private TypedProperties props;
    private SimpleString key;

    private static void assertEqualsTypeProperties(TypedProperties expected, TypedProperties actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)expected.getEncodeSize(), (long)actual.getEncodeSize());
        Assert.assertEquals((Object)expected.getPropertyNames(), (Object)actual.getPropertyNames());
        for (SimpleString key : actual.getPropertyNames()) {
            Object expectedValue = expected.getProperty(key);
            Object actualValue = actual.getProperty(key);
            if (expectedValue instanceof byte[] && actualValue instanceof byte[]) {
                byte[] expectedBytes = (byte[])expectedValue;
                byte[] actualBytes = (byte[])actualValue;
                Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
                continue;
            }
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
    }

    @Test
    public void testCopyContructor() throws Exception {
        this.props.putSimpleStringProperty(this.key, RandomUtil.randomSimpleString());
        TypedProperties copy = new TypedProperties(this.props);
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)copy.getEncodeSize());
        Assert.assertEquals((Object)this.props.getPropertyNames(), (Object)copy.getPropertyNames());
        Assert.assertTrue((boolean)copy.containsProperty(this.key));
        Assert.assertEquals((Object)this.props.getProperty(this.key), (Object)copy.getProperty(this.key));
    }

    @Test
    public void testRemove() throws Exception {
        this.props.putSimpleStringProperty(this.key, RandomUtil.randomSimpleString());
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNotNull((Object)this.props.getProperty(this.key));
        this.props.removeProperty(this.key);
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testClear() throws Exception {
        this.props.putSimpleStringProperty(this.key, RandomUtil.randomSimpleString());
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNotNull((Object)this.props.getProperty(this.key));
        this.props.clear();
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testKey() throws Exception {
        this.props.putBooleanProperty(this.key, true);
        boolean bool = (Boolean)this.props.getProperty(this.key);
        Assert.assertEquals((Object)true, (Object)bool);
        this.props.putCharProperty(this.key, 'a');
        char c = ((Character)this.props.getProperty(this.key)).charValue();
        Assert.assertEquals((long)97L, (long)c);
    }

    @Test
    public void testGetPropertyOnEmptyProperties() throws Exception {
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testRemovePropertyOnEmptyProperties() throws Exception {
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.removeProperty(this.key));
    }

    @Test
    public void testNullProperty() throws Exception {
        this.props.putSimpleStringProperty(this.key, null);
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testBytesPropertyWithNull() throws Exception {
        this.props.putBytesProperty(this.key, null);
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        byte[] bb = (byte[])this.props.getProperty(this.key);
        Assert.assertNull((Object)bb);
    }

    @Test
    public void testTypedProperties() throws Exception {
        SimpleString longKey = RandomUtil.randomSimpleString();
        long longValue = RandomUtil.randomLong();
        SimpleString simpleStringKey = RandomUtil.randomSimpleString();
        SimpleString simpleStringValue = RandomUtil.randomSimpleString();
        TypedProperties otherProps = new TypedProperties();
        otherProps.putLongProperty(longKey, longValue);
        otherProps.putSimpleStringProperty(simpleStringKey, simpleStringValue);
        this.props.putTypedProperties(otherProps);
        long ll = this.props.getLongProperty(longKey);
        Assert.assertEquals((long)longValue, (long)ll);
        SimpleString ss = this.props.getSimpleStringProperty(simpleStringKey);
        Assert.assertEquals((Object)simpleStringValue, (Object)ss);
    }

    @Test
    public void testEmptyTypedProperties() throws Exception {
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
        this.props.putTypedProperties(new TypedProperties());
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
    }

    @Test
    public void testNullTypedProperties() throws Exception {
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
        this.props.putTypedProperties(null);
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
    }

    @Test
    public void testEncodeDecode() throws Exception {
        this.props.putByteProperty(RandomUtil.randomSimpleString(), RandomUtil.randomByte());
        this.props.putBytesProperty(RandomUtil.randomSimpleString(), RandomUtil.randomBytes());
        this.props.putBytesProperty(RandomUtil.randomSimpleString(), null);
        this.props.putBooleanProperty(RandomUtil.randomSimpleString(), RandomUtil.randomBoolean());
        this.props.putShortProperty(RandomUtil.randomSimpleString(), RandomUtil.randomShort());
        this.props.putIntProperty(RandomUtil.randomSimpleString(), RandomUtil.randomInt());
        this.props.putLongProperty(RandomUtil.randomSimpleString(), RandomUtil.randomLong());
        this.props.putFloatProperty(RandomUtil.randomSimpleString(), RandomUtil.randomFloat());
        this.props.putDoubleProperty(RandomUtil.randomSimpleString(), RandomUtil.randomDouble());
        this.props.putCharProperty(RandomUtil.randomSimpleString(), RandomUtil.randomChar());
        this.props.putSimpleStringProperty(RandomUtil.randomSimpleString(), RandomUtil.randomSimpleString());
        this.props.putSimpleStringProperty(RandomUtil.randomSimpleString(), null);
        SimpleString keyToRemove = RandomUtil.randomSimpleString();
        this.props.putSimpleStringProperty(keyToRemove, RandomUtil.randomSimpleString());
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        this.props.encode(buffer);
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)buffer.writerIndex());
        TypedProperties decodedProps = new TypedProperties();
        decodedProps.decode(buffer);
        TypedPropertiesTest.assertEqualsTypeProperties(this.props, decodedProps);
        buffer.clear();
        this.props.removeProperty(keyToRemove);
        this.props.encode(buffer);
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)buffer.writerIndex());
    }

    @Test
    public void testEncodeDecodeEmpty() throws Exception {
        TypedProperties emptyProps = new TypedProperties();
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        emptyProps.encode(buffer);
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)buffer.writerIndex());
        TypedProperties decodedProps = new TypedProperties();
        decodedProps.decode(buffer);
        TypedPropertiesTest.assertEqualsTypeProperties(emptyProps, decodedProps);
    }

    @Before
    public void setUp() throws Exception {
        this.props = new TypedProperties();
        this.key = RandomUtil.randomSimpleString();
    }
}

