/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class ByteUtilTest {
    @Test
    public void testBytesToString() {
        byte[] byteArray = new byte[]{0, 1, 2, 3};
        this.testEquals("0001 0203", ByteUtil.bytesToHex((byte[])byteArray, (int)2));
        this.testEquals("00 01 02 03", ByteUtil.bytesToHex((byte[])byteArray, (int)1));
        this.testEquals("000102 03", ByteUtil.bytesToHex((byte[])byteArray, (int)3));
    }

    @Test
    public void testNonASCII() {
        Assert.assertEquals((Object)"aA", (Object)ByteUtil.toSimpleString((byte[])new byte[]{97, 0, 65, 0}));
        Assert.assertEquals((Object)"@@@@@", (Object)ByteUtil.toSimpleString((byte[])new byte[]{0, 97, 0, 65}));
        System.out.println(ByteUtil.toSimpleString((byte[])new byte[]{0, 97, 0, 65}));
    }

    @Test
    public void testMaxString() {
        byte[] byteArray = new byte[20480];
        System.out.println(ByteUtil.maxString((String)ByteUtil.bytesToHex((byte[])byteArray, (int)2), (int)150));
    }

    void testEquals(String string1, String string2) {
        if (!string1.equals(string2)) {
            Assert.fail((String)("String are not the same:=" + string1 + "!=" + string2));
        }
    }

    @Test
    public void testTextBytesToLongBytes() {
        long[] factor = new long[]{1L, 5L, 10L};
        String[] type = new String[]{"", "b", "k", "m", "g"};
        long[] size = new long[]{1L, 1L, 1024L, 0x100000L, 0x40000000L};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < type.length; ++j) {
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j])));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j])));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j].toUpperCase())));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j].toUpperCase())));
                if (j < 2) continue;
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j] + "b")));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j] + "b")));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j].toUpperCase() + "B")));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j].toUpperCase() + "B")));
            }
        }
    }

    @Test
    public void testTextBytesToLongBytesNegative() {
        try {
            ByteUtil.convertTextBytes((String)"x");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

