/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.SimpleFuture;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SimpleFutureTest {
    @Rule
    public ThreadLeakCheckRule threadLeakCheckRule = new ThreadLeakCheckRule();

    @Test
    public void testFuture() throws Exception {
        final long randomStart = System.currentTimeMillis();
        final SimpleFuture simpleFuture = new SimpleFuture();
        Thread t = new Thread(){

            @Override
            public void run() {
                simpleFuture.set((Object)randomStart);
            }
        };
        t.start();
        Assert.assertEquals((long)randomStart, (long)((Long)simpleFuture.get()));
    }

    @Test
    public void testException() throws Exception {
        final SimpleFuture simpleFuture = new SimpleFuture();
        Thread t = new Thread(){

            @Override
            public void run() {
                simpleFuture.fail(new Exception("hello"));
            }
        };
        t.start();
        boolean failed = false;
        try {
            simpleFuture.get();
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }
}

