/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkHealthTest {
    private static final InetAddress INVALID_ADDRESS;
    private static String IPV6_LOCAL;
    Set<NetworkHealthCheck> list = new HashSet<NetworkHealthCheck>();
    HttpServer httpServer;
    final ReusableLatch latch = new ReusableLatch(1);
    ActiveMQComponent component = new ActiveMQComponent(){
        boolean started = true;

        public void start() throws Exception {
            this.started = true;
            NetworkHealthTest.this.latch.countDown();
        }

        public void stop() throws Exception {
            this.started = false;
            NetworkHealthTest.this.latch.countDown();
        }

        public boolean isStarted() {
            return this.started;
        }
    };

    NetworkHealthCheck addCheck(NetworkHealthCheck check) {
        this.list.add(check);
        return check.setIgnoreLoopback(true);
    }

    @Before
    public void before() throws Exception {
        this.latch.setCount(1);
    }

    private void startHTTPServer() throws IOException {
        Assert.assertNull((Object)this.httpServer);
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 8080);
        this.httpServer = HttpServer.create(address, 100);
        this.httpServer.start();
        this.httpServer.createContext("/", new HttpHandler(){

            @Override
            public void handle(HttpExchange t) throws IOException {
                String response = "<html><body><b>This is a unit test</b></body></html>";
                t.sendResponseHeaders(200, response.length());
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
            }
        });
    }

    private void stopHTTPServer() {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.httpServer = null;
        }
    }

    @After
    public void after() {
        this.stopHTTPServer();
        for (NetworkHealthCheck check : this.list) {
            check.stop();
        }
    }

    @Test
    public void testCheck6() throws Exception {
        NetworkHealthCheck check = this.addCheck(new NetworkHealthCheck(null, 100L, 100));
        check.addComponent(this.component);
        InetAddress address = InetAddress.getByName(IPV6_LOCAL);
        Assert.assertTrue((boolean)(address instanceof Inet6Address));
        Assert.assertTrue((boolean)check.purePing(address));
        Assert.assertTrue((boolean)check.check(address));
    }

    @Test
    public void testParseSpaces() throws Exception {
        NetworkHealthCheck check = this.addCheck(new NetworkHealthCheck(null, 100L, 100));
        check.parseAddressList("localhost, , 127.0.0.2").parseURIList("http://www.redhat.com, , http://www.apache.org");
        Assert.assertEquals((long)2L, (long)check.getAddresses().size());
        Assert.assertEquals((long)2L, (long)check.getUrls().size());
    }

    @Test
    public void testParseLogger() throws Exception {
        NetworkHealthCheck check = this.addCheck(new NetworkHealthCheck(null, 100L, 100));
        check.parseAddressList("localhost, , 127.0.0.2").parseURIList("http://www.redhat.com, , http://www.apache.org");
        Assert.assertEquals((long)2L, (long)check.getAddresses().size());
        Assert.assertEquals((long)2L, (long)check.getUrls().size());
    }

    @Test
    public void testPings() throws Exception {
        this.doCheck("127.0.0.1");
    }

    private void doCheck(String localaddress) throws Exception {
        NetworkHealthCheck check = this.addCheck(new NetworkHealthCheck(null, 100L, 100));
        check.addComponent(this.component);
        InetAddress address = InetAddress.getByName(localaddress);
        Assert.assertTrue((boolean)check.check(address));
        Assert.assertTrue((boolean)check.purePing(address));
        Assert.assertFalse((boolean)check.purePing(INVALID_ADDRESS));
    }

    @Test
    public void testPingsIPV6() throws Exception {
        this.doCheck(IPV6_LOCAL);
    }

    @Test
    public void testCheckNoNodes() throws Exception {
        NetworkHealthCheck check = this.addCheck(new NetworkHealthCheck());
        Assert.assertTrue((boolean)check.check());
    }

    @Test
    public void testCheckUsingHTTP() throws Exception {
        this.startHTTPServer();
        NetworkHealthCheck check = this.addCheck(new NetworkHealthCheck(null, 100L, 1000));
        Assert.assertTrue((boolean)check.check(new URL("http://localhost:8080")));
        this.stopHTTPServer();
        Assert.assertFalse((boolean)check.check(new URL("http://localhost:8080")));
        check.addComponent(this.component);
        URL url = new URL("http://localhost:8080");
        Assert.assertFalse((boolean)check.check(url));
        this.startHTTPServer();
        Assert.assertTrue((boolean)check.check(url));
        check.addURL(url);
        Assert.assertFalse((boolean)this.latch.await(500L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.component.isStarted());
        this.stopHTTPServer();
        Assert.assertTrue((boolean)this.latch.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)this.component.isStarted());
        this.latch.setCount(1);
        this.startHTTPServer();
        Assert.assertTrue((boolean)this.latch.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.component.isStarted());
    }

    static {
        IPV6_LOCAL = "::1";
        InetAddress address = null;
        try {
            address = InetAddress.getByName("203.0.113.1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INVALID_ADDRESS = address;
    }
}

