/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.ConcurrentSet;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcurrentHashSetTest
extends Assert {
    private ConcurrentSet<String> set;
    private String element;

    @Test
    public void testAdd() throws Exception {
        Assert.assertTrue((boolean)this.set.add((Object)this.element));
        Assert.assertFalse((boolean)this.set.add((Object)this.element));
    }

    @Test
    public void testAddIfAbsent() throws Exception {
        Assert.assertTrue((boolean)this.set.addIfAbsent((Object)this.element));
        Assert.assertFalse((boolean)this.set.addIfAbsent((Object)this.element));
    }

    @Test
    public void testRemove() throws Exception {
        Assert.assertTrue((boolean)this.set.add((Object)this.element));
        Assert.assertTrue((boolean)this.set.remove((Object)this.element));
        Assert.assertFalse((boolean)this.set.remove((Object)this.element));
    }

    @Test
    public void testContains() throws Exception {
        Assert.assertFalse((boolean)this.set.contains((Object)this.element));
        Assert.assertTrue((boolean)this.set.add((Object)this.element));
        Assert.assertTrue((boolean)this.set.contains((Object)this.element));
        Assert.assertTrue((boolean)this.set.remove((Object)this.element));
        Assert.assertFalse((boolean)this.set.contains((Object)this.element));
    }

    @Test
    public void testSize() throws Exception {
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.add((Object)this.element));
        Assert.assertEquals((long)1L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.remove((Object)this.element));
        Assert.assertEquals((long)0L, (long)this.set.size());
    }

    @Test
    public void testClear() throws Exception {
        Assert.assertTrue((boolean)this.set.add((Object)this.element));
        Assert.assertTrue((boolean)this.set.contains((Object)this.element));
        this.set.clear();
        Assert.assertFalse((boolean)this.set.contains((Object)this.element));
    }

    @Test
    public void testIsEmpty() throws Exception {
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertTrue((boolean)this.set.add((Object)this.element));
        Assert.assertFalse((boolean)this.set.isEmpty());
        this.set.clear();
        Assert.assertTrue((boolean)this.set.isEmpty());
    }

    @Test
    public void testIterator() throws Exception {
        this.set.add((Object)this.element);
        for (String e : this.set) {
            Assert.assertEquals((Object)this.element, (Object)e);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.set = new ConcurrentHashSet();
        this.element = RandomUtil.randomString();
    }
}

