/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.stomp;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.activemq.apollo.broker.store.MessageRecord;
import org.apache.activemq.apollo.broker.store.ZeroCopyBuffer;
import org.apache.activemq.apollo.broker.store.ZeroCopyBufferAllocator;
import org.apache.activemq.apollo.stomp.BufferContent;
import org.apache.activemq.apollo.stomp.Stomp$;
import org.apache.activemq.apollo.stomp.StompCodec$;
import org.apache.activemq.apollo.stomp.StompContent;
import org.apache.activemq.apollo.stomp.StompFrame;
import org.apache.activemq.apollo.stomp.StompFrame$;
import org.apache.activemq.apollo.stomp.StompFrameMessage;
import org.apache.activemq.apollo.stomp.ZeroCopyContent;
import org.apache.activemq.apollo.transport.ProtocolCodec;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\ruw!B\u0001\u0003\u0011\u000bi\u0011AC*u_6\u00048i\u001c3fG*\u00111\u0001B\u0001\u0006gR|W\u000e\u001d\u0006\u0003\u000b\u0019\ta!\u00199pY2|'BA\u0004\t\u0003!\t7\r^5wK6\f(BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0015\u0011C\u0001\u0006Ti>l\u0007oQ8eK\u000e\u001cBa\u0004\n\u001bAA\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005Y\u0006twMC\u0001\u0018\u0003\u0011Q\u0017M^1\n\u0005e!\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\t\u0005!Q\u000f^5m\u0013\tyBDA\u0002M_\u001e\u0004\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121bU2bY\u0006|%M[3di\")qe\u0004C\u0001Q\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\bU=\u0001\r\u0011\"\u0001,\u0003Ii\u0017\r_0d_6l\u0017M\u001c3`Y\u0016tw\r\u001e5\u0016\u00031\u0002\"!I\u0017\n\u00059\u0012#aA%oi\"9\u0001g\u0004a\u0001\n\u0003\t\u0014AF7bq~\u001bw.\\7b]\u0012|F.\u001a8hi\"|F%Z9\u0015\u0005I*\u0004CA\u00114\u0013\t!$E\u0001\u0003V]&$\bb\u0002\u001c0\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0004B\u0002\u001d\u0010A\u0003&A&A\nnCb|6m\\7nC:$w\f\\3oORD\u0007\u0005C\u0003;\u001f\u0011\u00051(\u0001\u0004f]\u000e|G-\u001a\u000b\u0003y\u0011\u0003\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000bM$xN]3\u000b\u0005\u0005#\u0011A\u00022s_.,'/\u0003\u0002D}\tiQ*Z:tC\u001e,'+Z2pe\u0012DQ!R\u001dA\u0002\u0019\u000bq!\\3tg\u0006<W\r\u0005\u0002\u000f\u000f&\u0011\u0001J\u0001\u0002\u0012'R|W\u000e\u001d$sC6,W*Z:tC\u001e,\u0007\"\u0002&\u0010\t\u0003Y\u0015A\u00023fG>$W\r\u0006\u0002G\u0019\")Q)\u0013a\u0001y!9ajDb\u0001\n\u0003y\u0015A\u0005\u0013f]\u0006\u0014G.Z0bgN,'\u000f^5p]N,\u0012\u0001\u0015\t\u0003CEK!A\u0015\u0012\u0003\u000f\t{w\u000e\\3b]\"1Ak\u0004Q\u0001\nA\u000b1\u0003J3oC\ndWmX1tg\u0016\u0014H/[8og\u00022A\u0001\u0005\u0002\u0001-N!QKE,!!\tA6,D\u0001Z\u0015\tQF!A\u0005ue\u0006t7\u000f]8si&\u0011A,\u0017\u0002\u000e!J|Go\\2pY\u000e{G-Z2\t\u000b\u001d*F\u0011\u00010\u0015\u0003}\u0003\"AD+\t\u000f\u0005,\u0006\u0019!C\u0001W\u0005\tR.\u0019=`Q\u0016\fG-\u001a:`Y\u0016tw\r\u001e5\t\u000f\r,\u0006\u0019!C\u0001I\u0006)R.\u0019=`Q\u0016\fG-\u001a:`Y\u0016tw\r\u001e5`I\u0015\fHC\u0001\u001af\u0011\u001d1$-!AA\u00021BaaZ+!B\u0013a\u0013AE7bq~CW-\u00193fe~cWM\\4uQ\u0002Bq![+A\u0002\u0013\u00051&A\u0006nCb|\u0006.Z1eKJ\u001c\bbB6V\u0001\u0004%\t\u0001\\\u0001\u0010[\u0006Dx\f[3bI\u0016\u00148o\u0018\u0013fcR\u0011!'\u001c\u0005\bm)\f\t\u00111\u0001-\u0011\u0019yW\u000b)Q\u0005Y\u0005aQ.\u0019=`Q\u0016\fG-\u001a:tA!9\u0011/\u0016a\u0001\n\u0003Y\u0013aD7bq~#\u0017\r^1`Y\u0016tw\r\u001e5\t\u000fM,\u0006\u0019!C\u0001i\u0006\u0019R.\u0019=`I\u0006$\u0018m\u00187f]\u001e$\bn\u0018\u0013fcR\u0011!'\u001e\u0005\bmI\f\t\u00111\u0001-\u0011\u00199X\u000b)Q\u0005Y\u0005\u0001R.\u0019=`I\u0006$\u0018m\u00187f]\u001e$\b\u000e\t\u0005\bsV\u0003\r\u0011\"\u0001{\u0003iQXM]8`G>\u0004\u0018p\u00182vM\u001a,'oX1mY>\u001c\u0017\r^8s+\u0005Y\bCA\u001f}\u0013\tihHA\f[KJ|7i\u001c9z\u0005V4g-\u001a:BY2|7-\u0019;pe\"Aq0\u0016a\u0001\n\u0003\t\t!\u0001\u0010{KJ|wlY8qs~\u0013WO\u001a4fe~\u000bG\u000e\\8dCR|'o\u0018\u0013fcR\u0019!'a\u0001\t\u000fYr\u0018\u0011!a\u0001w\"9\u0011qA+!B\u0013Y\u0018a\u0007>fe>|6m\u001c9z?\n,hMZ3s?\u0006dGn\\2bi>\u0014\b\u0005C\u0004\u0002\fU#\u0019!!\u0004\u0002\t]\u0014\u0018\r\u001d\u000b\u0005\u0003\u001f\tY\u0002\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BF\u0001\u0004]&|\u0017\u0002BA\r\u0003'\u0011!BQ=uK\n+hMZ3s\u0011!\ti\"!\u0003A\u0002\u0005}\u0011!\u0001=\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u00059\u0001.Y<uEV4'bAA\u0015\u0015\u0005Qa-^:fg>,(oY3\n\t\u00055\u00121\u0005\u0002\u0007\u0005V4g-\u001a:\t\u000f\u0005-Q\u000bb\u0001\u00022Q!\u0011qBA\u001a\u0011!\ti\"a\fA\u0002\u0005U\u0002cA\u0011\u00028%\u0019\u0011\u0011\b\u0012\u0003\t\tKH/\u001a\u0005\b\u0003{)F\u0011AA \u0003!\u0001(o\u001c;pG>dGCAA!!\r\u0019\u00121I\u0005\u0004\u0003\u000b\"\"AB*ue&tw\r\u0003\u0005\u0002JU\u0003\r\u0011\"\u0001,\u0003E9(/\u001b;f?\n,hMZ3s?NL'0\u001a\u0005\n\u0003\u001b*\u0006\u0019!C\u0001\u0003\u001f\nQc\u001e:ji\u0016|&-\u001e4gKJ|6/\u001b>f?\u0012*\u0017\u000fF\u00023\u0003#B\u0001BNA&\u0003\u0003\u0005\r\u0001\f\u0005\b\u0003+*\u0006\u0015)\u0003-\u0003I9(/\u001b;f?\n,hMZ3s?NL'0\u001a\u0011\t\u0013\u0005eS\u000b1A\u0005\u0002\u0005m\u0013!D<sSR,wlY8v]R,'/\u0006\u0002\u0002^A\u0019\u0011%a\u0018\n\u0007\u0005\u0005$E\u0001\u0003M_:<\u0007\"CA3+\u0002\u0007I\u0011AA4\u0003E9(/\u001b;f?\u000e|WO\u001c;fe~#S-\u001d\u000b\u0004e\u0005%\u0004\"\u0003\u001c\u0002d\u0005\u0005\t\u0019AA/\u0011!\ti'\u0016Q!\n\u0005u\u0013AD<sSR,wlY8v]R,'\u000f\t\u0005\n\u0003c*\u0006\u0019!C\u0001\u0003g\nQb\u001e:ji\u0016|6\r[1o]\u0016dWCAA;!\u0011\t9(! \u000e\u0005\u0005e$\u0002BA>\u0003'\t\u0001b\u00195b]:,Gn]\u0005\u0005\u0003\u007f\nIHA\nXe&$\u0018M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0005\u0002\u0004V\u0003\r\u0011\"\u0001\u0002\u0006\u0006\trO]5uK~\u001b\u0007.\u00198oK2|F%Z9\u0015\u0007I\n9\tC\u00057\u0003\u0003\u000b\t\u00111\u0001\u0002v!A\u00111R+!B\u0013\t)(\u0001\bxe&$XmX2iC:tW\r\u001c\u0011\t\u0013\u0005=U\u000b1A\u0005\u0002\u0005E\u0015!\u00058fqR|vO]5uK~\u0013WO\u001a4feV\u0011\u00111\u0013\t\u0005\u0003C\t)*\u0003\u0003\u0002\u0018\u0006\r\"!\u0007#bi\u0006\u0014\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6D\u0011\"a'V\u0001\u0004%\t!!(\u0002+9,\u0007\u0010^0xe&$Xm\u00182vM\u001a,'o\u0018\u0013fcR\u0019!'a(\t\u0013Y\nI*!AA\u0002\u0005M\u0005\u0002CAR+\u0002\u0006K!a%\u0002%9,\u0007\u0010^0xe&$Xm\u00182vM\u001a,'\u000f\t\u0005\n\u0003O+\u0006\u0019!C\u0001\u0003S\u000b\u0011C\\3yi~;(/\u001b;f?\u0012L'/Z2u+\t\tY\u000bE\u0002>\u0003[K1!a,?\u00059QVM]8D_BL()\u001e4gKJD\u0011\"a-V\u0001\u0004%\t!!.\u0002+9,\u0007\u0010^0xe&$Xm\u00183je\u0016\u001cGo\u0018\u0013fcR\u0019!'a.\t\u0013Y\n\t,!AA\u0002\u0005-\u0006\u0002CA^+\u0002\u0006K!a+\u0002%9,\u0007\u0010^0xe&$Xm\u00183je\u0016\u001cG\u000f\t\u0005\n\u0003\u007f+\u0006\u0019!C\u0001\u0003\u0003\fAb\u001e:ji\u0016|&-\u001e4gKJ,\"!a\u0004\t\u0013\u0005\u0015W\u000b1A\u0005\u0002\u0005\u001d\u0017\u0001E<sSR,wLY;gM\u0016\u0014x\fJ3r)\r\u0011\u0014\u0011\u001a\u0005\nm\u0005\r\u0017\u0011!a\u0001\u0003\u001fA\u0001\"!4VA\u0003&\u0011qB\u0001\u000eoJLG/Z0ck\u001a4WM\u001d\u0011\t\u0013\u0005EW\u000b1A\u0005\u0002\u0005%\u0016\u0001D<sSR,w\fZ5sK\u000e$\b\"CAk+\u0002\u0007I\u0011AAl\u0003A9(/\u001b;f?\u0012L'/Z2u?\u0012*\u0017\u000fF\u00023\u00033D\u0011BNAj\u0003\u0003\u0005\r!a+\t\u0011\u0005uW\u000b)Q\u0005\u0003W\u000bQb\u001e:ji\u0016|F-\u001b:fGR\u0004\u0003\u0002CAq+\u0002\u0007I\u0011A\u0016\u0002!]\u0014\u0018\u000e^3`I&\u0014Xm\u0019;`a>\u001c\b\"CAs+\u0002\u0007I\u0011AAt\u0003Q9(/\u001b;f?\u0012L'/Z2u?B|7o\u0018\u0013fcR\u0019!'!;\t\u0011Y\n\u0019/!AA\u00021Bq!!<VA\u0003&A&A\txe&$Xm\u00183je\u0016\u001cGo\u00189pg\u0002Bq!!=V\t\u0003\t\u00190\u0001\u0003gk2dG#\u0001)\t\r\u0005]X\u000b\"\u0001P\u0003!I7oX3naRL\bbBA~+\u0012\u0005\u0011Q`\u0001\u0017g\u0016$xK]5uC\ndWMQ=uK\u000eC\u0017M\u001c8fYR\u0019!'a@\t\u0011\t\u0005\u0011\u0011 a\u0001\u0003k\nqa\u00195b]:,G\u000eC\u0004\u0003\u0006U#\tAa\u0002\u0002\u001f\u001d,Go\u0016:ji\u0016\u001cu.\u001e8uKJ$\"!!\u0018\t\u000f\t-Q\u000b\"\u0001\u0003\u000e\u0005)qO]5uKR!!q\u0002B\u000f!\u0011\u0011\tBa\u0006\u000f\u0007a\u0013\u0019\"C\u0002\u0003\u0016e\u000bQ\u0002\u0015:pi>\u001cw\u000e\\\"pI\u0016\u001c\u0017\u0002\u0002B\r\u00057\u00111BQ;gM\u0016\u00148\u000b^1uK*\u0019!QC-\t\u0011\t}!\u0011\u0002a\u0001\u0005C\tqaY8n[\u0006tG\rE\u0002\"\u0005GI1A!\n#\u0005\r\te.\u001f\u0005\u0007uU#\tA!\u000b\u0015\u000bI\u0012YC!\u000e\t\u0011\t5\"q\u0005a\u0001\u0005_\tQA\u001a:b[\u0016\u00042A\u0004B\u0019\u0013\r\u0011\u0019D\u0001\u0002\u000b'R|W\u000e\u001d$sC6,\u0007\u0002\u0003B\u001c\u0005O\u0001\rA!\u000f\u0002\u0005=\u001c\b\u0003\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}b#\u0001\u0002j_&!!1\tB\u001f\u0005)!\u0015\r^1PkR\u0004X\u000f\u001e\u0005\b\u0005\u000f*F\u0011\u0001B%\u0003\u00151G.^:i)\t\u0011y!\u0002\u0004\u0003NU\u0003!q\n\u0002\f\rJ\fW.\u001a*fC\u0012,'\u000fE\u0004\"\u0005#\nyAa\f\n\u0007\tM#EA\u0005Gk:\u001cG/[8oc!I!qK+A\u0002\u0013\u0005\u00111L\u0001\re\u0016\fGmX2pk:$XM\u001d\u0005\n\u00057*\u0006\u0019!C\u0001\u0005;\n\u0001C]3bI~\u001bw.\u001e8uKJ|F%Z9\u0015\u0007I\u0012y\u0006C\u00057\u00053\n\t\u00111\u0001\u0002^!A!1M+!B\u0013\ti&A\u0007sK\u0006$wlY8v]R,'\u000f\t\u0005\t\u0005O*\u0006\u0019!C\u0001W\u0005\u0001\"/Z1e?\n,hMZ3s?NL'0\u001a\u0005\n\u0005W*\u0006\u0019!C\u0001\u0005[\nAC]3bI~\u0013WO\u001a4fe~\u001b\u0018N_3`I\u0015\fHc\u0001\u001a\u0003p!AaG!\u001b\u0002\u0002\u0003\u0007A\u0006C\u0004\u0003tU\u0003\u000b\u0015\u0002\u0017\u0002#I,\u0017\rZ0ck\u001a4WM]0tSj,\u0007\u0005C\u0005\u0003xU\u0003\r\u0011\"\u0001\u0003z\u0005a!/Z1e?\u000eD\u0017M\u001c8fYV\u0011!1\u0010\t\u0005\u0003o\u0012i(\u0003\u0003\u0003\u0000\u0005e$a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007\"\u0003BB+\u0002\u0007I\u0011\u0001BC\u0003A\u0011X-\u00193`G\"\fgN\\3m?\u0012*\u0017\u000fF\u00023\u0005\u000fC\u0011B\u000eBA\u0003\u0003\u0005\rAa\u001f\t\u0011\t-U\u000b)Q\u0005\u0005w\nQB]3bI~\u001b\u0007.\u00198oK2\u0004\u0003\"\u0003BH+\u0002\u0007I\u0011AAa\u0003-\u0011X-\u00193`EV4g-\u001a:\t\u0013\tMU\u000b1A\u0005\u0002\tU\u0015a\u0004:fC\u0012|&-\u001e4gKJ|F%Z9\u0015\u0007I\u00129\nC\u00057\u0005#\u000b\t\u00111\u0001\u0002\u0010!A!1T+!B\u0013\ty!\u0001\u0007sK\u0006$wLY;gM\u0016\u0014\b\u0005\u0003\u0005\u0003 V\u0003\r\u0011\"\u0001,\u0003!\u0011X-\u00193`K:$\u0007\"\u0003BR+\u0002\u0007I\u0011\u0001BS\u00031\u0011X-\u00193`K:$w\fJ3r)\r\u0011$q\u0015\u0005\tm\t\u0005\u0016\u0011!a\u0001Y!9!1V+!B\u0013a\u0013!\u0003:fC\u0012|VM\u001c3!\u0011!\u0011y+\u0016a\u0001\n\u0003Y\u0013A\u0003:fC\u0012|6\u000f^1si\"I!1W+A\u0002\u0013\u0005!QW\u0001\u000fe\u0016\fGmX:uCJ$x\fJ3r)\r\u0011$q\u0017\u0005\tm\tE\u0016\u0011!a\u0001Y!9!1X+!B\u0013a\u0013a\u0003:fC\u0012|6\u000f^1si\u0002B\u0011Ba0V\u0001\u0004%\t!!+\u0002\u0017I,\u0017\rZ0eSJ,7\r\u001e\u0005\n\u0005\u0007,\u0006\u0019!C\u0001\u0005\u000b\fqB]3bI~#\u0017N]3di~#S-\u001d\u000b\u0004e\t\u001d\u0007\"\u0003\u001c\u0003B\u0006\u0005\t\u0019AAV\u0011!\u0011Y-\u0016Q!\n\u0005-\u0016\u0001\u0004:fC\u0012|F-\u001b:fGR\u0004\u0003\u0002\u0003Bh+\u0002\u0007I\u0011A\u0016\u0002\u001fI,\u0017\rZ0eSJ,7\r^0q_ND\u0011Ba5V\u0001\u0004%\tA!6\u0002'I,\u0017\rZ0eSJ,7\r^0q_N|F%Z9\u0015\u0007I\u00129\u000e\u0003\u00057\u0005#\f\t\u00111\u0001-\u0011\u001d\u0011Y.\u0016Q!\n1\n\u0001C]3bI~#\u0017N]3di~\u0003xn\u001d\u0011\t\u0013\t}W\u000b1A\u0005\u0002\t\u0005\u0018a\u00038fqR|\u0016m\u0019;j_:,\"Aa9\u0011\t\t\u0015(1J\u0007\u0002+\"I!\u0011^+A\u0002\u0013\u0005!1^\u0001\u0010]\u0016DHoX1di&|gn\u0018\u0013fcR\u0019!G!<\t\u0013Y\u00129/!AA\u0002\t\r\b\u0002\u0003By+\u0002\u0006KAa9\u0002\u00199,\u0007\u0010^0bGRLwN\u001c\u0011\t\u0011\tUX\u000b1A\u0005\u0002=\u000bA\u0001\u001e:j[\"I!\u0011`+A\u0002\u0013\u0005!1`\u0001\tiJLWn\u0018\u0013fcR\u0019!G!@\t\u0011Y\u001290!AA\u0002ACqa!\u0001VA\u0003&\u0001+A\u0003ue&l\u0007\u0005C\u0004\u0004\u0006U#\taa\u0002\u0002-M,GOU3bI\u0006\u0014G.\u001a\"zi\u0016\u001c\u0005.\u00198oK2$2AMB\u0005\u0011!\u0011\taa\u0001A\u0002\tm\u0004bBB\u0007+\u0012\u00051qB\u0001\u0007k:\u0014X-\u00193\u0015\u0007I\u001a\t\u0002\u0003\u0005\u0004\u0014\r-\u0001\u0019AA\u0010\u0003\u0019\u0011WO\u001a4fe\"91qC+\u0005\u0002\t\u001d\u0011AD4fiJ+\u0017\rZ\"pk:$XM\u001d\u0005\b\u00077)F\u0011IB\u000f\u0003\u0011\u0011X-\u00193\u0015\u0003IAqa!\tV\t\u0003\u0019\u0019#A\u0005sK\u0006$w\f\\5oKRA\u0011qDB\u0013\u0007O\u0019Y\u0003\u0003\u0005\u0004\u0014\r}\u0001\u0019AA\b\u0011\u001d\u0019Ica\bA\u00021\n1!\\1y\u0011!\u0019ica\bA\u0002\r=\u0012\u0001D3se>\u0014X*Z:tC\u001e,\u0007\u0003BB\u0019\u0007oq1!IB\u001a\u0013\r\u0019)DI\u0001\u0007!J,G-\u001a4\n\t\u0005\u00153\u0011\b\u0006\u0004\u0007k\u0011\u0003bBB\u001f+\u0012\u0005!\u0011]\u0001\fe\u0016\fGmX1di&|g\u000eC\u0004\u0004BU#\taa\u0011\u0002\u0019I,\u0017\rZ0iK\u0006$WM]:\u0015\r\t\r8QIB(\u0011!\u00199ea\u0010A\u0002\r%\u0013AB1di&|g\u000e\u0005\u0003\u0002\"\r-\u0013\u0002BB'\u0003G\u00111\"Q:dS&\u0014UO\u001a4fe\"Q1\u0011KB !\u0003\u0005\raa\u0015\u0002\u000f!,\u0017\rZ3sgB!1QKB.\u001d\rq1qK\u0005\u0004\u00073\u0012\u0011!B*u_6\u0004\u0018\u0002BB/\u0007?\u0012q\u0002S3bI\u0016\u0014X*\u00199Ck\u001a4WM\u001d\u0006\u0004\u00073\u0012\u0001bBB2+\u0012\u00051QM\u0001\u0004O\u0016$HCBB4\u0007[\u001ay\u0007E\u0003\"\u0007S\u001aI%C\u0002\u0004l\t\u0012aa\u00149uS>t\u0007\u0002CB)\u0007C\u0002\raa\u0015\t\u0011\rE4\u0011\ra\u0001\u0007\u0013\nAA\\1nK\"91QO+\u0005\u0002\r]\u0014a\u0006:fC\u0012|&-\u001b8bef|&m\u001c3z?\u0012L'/Z2u)!\u0011\u0019o!\u001f\u0004|\ru\u0004\u0002CB$\u0007g\u0002\ra!\u0013\t\u0011\rE31\u000fa\u0001\u0007'Bqaa \u0004t\u0001\u0007A&A\u0007d_:$XM\u001c;MK:<G\u000f\u001b\u0005\b\u0007\u0007+F\u0011ABC\u0003Y\u0011X-\u00193`I&\u0014Xm\u0019;`i\u0016\u0014X.\u001b8bi>\u0014HC\u0003Br\u0007\u000f\u001bIia#\u0004\u000e\"A1qIBA\u0001\u0004\u0019I\u0005\u0003\u0005\u0004R\r\u0005\u0005\u0019AB*\u0011\u001d\u0019yh!!A\u00021B\u0001ba$\u0004\u0002\u0002\u0007\u00111V\u0001\u0003[\u0006Dqaa%V\t\u0003\u0019)*A\u000bsK\u0006$wL\u001a:b[\u0016|F/\u001a:nS:\fGo\u001c:\u0015\u000bA\u001b9j!'\t\u0011\rM1\u0011\u0013a\u0001\u0003\u001fAqaa \u0004\u0012\u0002\u0007A\u0006C\u0004\u0004\u001eV#\taa(\u0002!I,\u0017\rZ0cS:\f'/_0c_\u0012LH\u0003\u0003Br\u0007C\u001b\u0019k!*\t\u0011\r\u001d31\u0014a\u0001\u0007\u0013B\u0001b!\u0015\u0004\u001c\u0002\u000711\u000b\u0005\b\u0007\u007f\u001aY\n1\u0001-\u0011\u001d\u0019I+\u0016C\u0001\u0007W\u000bAB]3bI~\u001bwN\u001c;f]R$b!a\b\u0004.\u000e=\u0006\u0002CB\n\u0007O\u0003\r!a\u0004\t\u000f\r}4q\u0015a\u0001Y!911W+\u0005\u0002\rU\u0016\u0001\u0004:fC\u0012|Fo\\0ok2dG\u0003BA\u0010\u0007oC\u0001ba\u0005\u00042\u0002\u0007\u0011q\u0002\u0005\b\u0007w+F\u0011AB_\u00039\u0011X-\u00193`i\u0016DHo\u00182pIf$bAa9\u0004@\u000e\u0005\u0007\u0002CB$\u0007s\u0003\ra!\u0013\t\u0011\rE3\u0011\u0018a\u0001\u0007'B\u0011b!2V#\u0003%\taa2\u0002-I,\u0017\rZ0iK\u0006$WM]:%I\u00164\u0017-\u001e7uII*\"a!3+\t\rM31Z\u0016\u0003\u0007\u001b\u0004Baa4\u0004Z6\u00111\u0011\u001b\u0006\u0005\u0007'\u001c).A\u0005v]\u000eDWmY6fI*\u00191q\u001b\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\\\u000eE'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class StompCodec
implements ProtocolCodec,
ScalaObject {
    private int max_header_length = 10240;
    private int max_headers = 1000;
    private int max_data_length = 0x6400000;
    private ZeroCopyBufferAllocator zero_copy_buffer_allocator = null;
    private int write_buffer_size = 65536;
    private long write_counter = 0L;
    private WritableByteChannel write_channel = null;
    private DataByteArrayOutputStream next_write_buffer = new DataByteArrayOutputStream(this.write_buffer_size());
    private ZeroCopyBuffer next_write_direct = null;
    private ByteBuffer write_buffer = ByteBuffer.allocate(0);
    private ZeroCopyBuffer write_direct = null;
    private int write_direct_pos = 0;
    private long read_counter = 0L;
    private int read_buffer_size = 65536;
    private ReadableByteChannel read_channel = null;
    private ByteBuffer read_buffer = ByteBuffer.allocate(this.read_buffer_size());
    private int read_end = 0;
    private int read_start = 0;
    private ZeroCopyBuffer read_direct = null;
    private int read_direct_pos = 0;
    private Function1<ByteBuffer, StompFrame> next_action = this.read_action();
    private boolean trim = true;

    public static final void trace(Throwable throwable) {
        StompCodec$.MODULE$.trace(throwable);
    }

    public static final void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.trace(throwable, function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Throwable throwable) {
        StompCodec$.MODULE$.debug(throwable);
    }

    public static final void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.debug(throwable, function0, seq);
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.debug(function0, seq);
    }

    public static final void info(Throwable throwable) {
        StompCodec$.MODULE$.info(throwable);
    }

    public static final void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.info(throwable, function0, seq);
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.info(function0, seq);
    }

    public static final void warn(Throwable throwable) {
        StompCodec$.MODULE$.warn(throwable);
    }

    public static final void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.warn(throwable, function0, seq);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.warn(function0, seq);
    }

    public static final void error(Throwable throwable) {
        StompCodec$.MODULE$.error(throwable);
    }

    public static final void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.error(throwable, function0, seq);
    }

    public static final void error(Function0<String> function0, Seq<Object> seq) {
        StompCodec$.MODULE$.error(function0, seq);
    }

    public static final void org$apache$activemq$apollo$util$Log$_setter_$log_$eq(Logger logger) {
        StompCodec$.MODULE$.org$apache$activemq$apollo$util$Log$_setter_$log_$eq(logger);
    }

    public static final Logger log() {
        return StompCodec$.MODULE$.log();
    }

    public static final boolean $enable_assertions() {
        return StompCodec$.MODULE$.$enable_assertions();
    }

    public static final StompFrameMessage decode(MessageRecord messageRecord) {
        return StompCodec$.MODULE$.decode(messageRecord);
    }

    public static final void max_command_length_$eq(int n) {
        StompCodec$.MODULE$.max_command_length_$eq(n);
    }

    public static final int max_command_length() {
        return StompCodec$.MODULE$.max_command_length();
    }

    public int max_header_length() {
        return this.max_header_length;
    }

    public void max_header_length_$eq(int n) {
        this.max_header_length = n;
    }

    public int max_headers() {
        return this.max_headers;
    }

    public void max_headers_$eq(int n) {
        this.max_headers = n;
    }

    public int max_data_length() {
        return this.max_data_length;
    }

    public void max_data_length_$eq(int n) {
        this.max_data_length = n;
    }

    public ZeroCopyBufferAllocator zero_copy_buffer_allocator() {
        return this.zero_copy_buffer_allocator;
    }

    public void zero_copy_buffer_allocator_$eq(ZeroCopyBufferAllocator zeroCopyBufferAllocator) {
        this.zero_copy_buffer_allocator = zeroCopyBufferAllocator;
    }

    public ByteBuffer wrap(org.fusesource.hawtbuf.Buffer x) {
        return ByteBuffer.wrap(x.data, x.offset, x.length);
    }

    public ByteBuffer wrap(byte x) {
        return ByteBuffer.wrap(Array$.MODULE$.apply(x, (Seq)Predef$.MODULE$.wrapByteArray(new byte[0])));
    }

    public String protocol() {
        return "stomp";
    }

    public int write_buffer_size() {
        return this.write_buffer_size;
    }

    public void write_buffer_size_$eq(int n) {
        this.write_buffer_size = n;
    }

    public long write_counter() {
        return this.write_counter;
    }

    public void write_counter_$eq(long l) {
        this.write_counter = l;
    }

    public WritableByteChannel write_channel() {
        return this.write_channel;
    }

    public void write_channel_$eq(WritableByteChannel writableByteChannel) {
        this.write_channel = writableByteChannel;
    }

    public DataByteArrayOutputStream next_write_buffer() {
        return this.next_write_buffer;
    }

    public void next_write_buffer_$eq(DataByteArrayOutputStream dataByteArrayOutputStream) {
        this.next_write_buffer = dataByteArrayOutputStream;
    }

    public ZeroCopyBuffer next_write_direct() {
        return this.next_write_direct;
    }

    public void next_write_direct_$eq(ZeroCopyBuffer zeroCopyBuffer) {
        this.next_write_direct = zeroCopyBuffer;
    }

    public ByteBuffer write_buffer() {
        return this.write_buffer;
    }

    public void write_buffer_$eq(ByteBuffer byteBuffer) {
        this.write_buffer = byteBuffer;
    }

    public ZeroCopyBuffer write_direct() {
        return this.write_direct;
    }

    public void write_direct_$eq(ZeroCopyBuffer zeroCopyBuffer) {
        this.write_direct = zeroCopyBuffer;
    }

    public int write_direct_pos() {
        return this.write_direct_pos;
    }

    public void write_direct_pos_$eq(int n) {
        this.write_direct_pos = n;
    }

    public boolean full() {
        return this.next_write_direct() != null || this.next_write_buffer().size() >= this.write_buffer_size() >> 1;
    }

    public boolean is_empty() {
        return this.write_buffer().remaining() == 0 && this.write_direct() == null;
    }

    public void setWritableByteChannel(WritableByteChannel channel) {
        this.write_channel_$eq(channel);
        if (this.write_channel() instanceof SocketChannel) {
            ((SocketChannel)this.write_channel()).socket().setSendBufferSize(this.write_buffer_size());
        }
    }

    public long getWriteCounter() {
        return this.write_counter();
    }

    public ProtocolCodec.BufferState write(Object command) {
        Object object;
        block6: {
            ProtocolCodec.BufferState bufferState;
            block3: {
                boolean was_empty;
                block5: {
                    block4: {
                        block2: {
                            if (!this.full()) break block2;
                            bufferState = ProtocolCodec.BufferState.FULL;
                            break block3;
                        }
                        was_empty = this.is_empty();
                        object = command;
                        if (!(object instanceof org.fusesource.hawtbuf.Buffer)) break block4;
                        ((org.fusesource.hawtbuf.Buffer)object).writeTo((DataOutput)this.next_write_buffer());
                        break block5;
                    }
                    if (!(object instanceof StompFrame)) break block6;
                    this.encode((StompFrame)object, (DataOutput)this.next_write_buffer());
                }
                bufferState = was_empty ? ProtocolCodec.BufferState.WAS_EMPTY : ProtocolCodec.BufferState.NOT_EMPTY;
            }
            return bufferState;
        }
        throw new MatchError(object);
    }

    public void encode(StompFrame frame, DataOutput os$2) {
        frame.action().writeTo(os$2);
        os$2.write(Stomp$.MODULE$.NEWLINE());
        if (!frame.updated_headers().isEmpty()) {
            ((LinearSeqOptimized)frame.updated_headers().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this, os$2){
                public static final long serialVersionUID;
                private final DataOutput os$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    if (tuple22 != null) {
                        ((org.fusesource.hawtbuf.Buffer)tuple22._1()).writeTo(this.os$2);
                        this.os$2.write(Stomp$.MODULE$.COLON());
                        ((org.fusesource.hawtbuf.Buffer)tuple22._2()).writeTo(this.os$2);
                        this.os$2.write(Stomp$.MODULE$.NEWLINE());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.os$2 = dataOutput;
                }
            });
        }
        if (frame.are_headers_in_content_buffer()) {
            int offset = ((org.fusesource.hawtbuf.Buffer)((Tuple2)frame.headers().head())._1()).offset;
            AsciiBuffer buffer1 = (AsciiBuffer)((Tuple2)frame.headers().head())._1();
            org.fusesource.hawtbuf.Buffer buffer2 = ((BufferContent)frame.content()).content();
            int length = buffer2.offset - buffer1.offset + buffer2.length;
            os$2.write(buffer1.data, offset, length);
            Stomp$.MODULE$.END_OF_FRAME_BUFFER().writeTo(os$2);
        } else {
            ((LinearSeqOptimized)frame.headers().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this, os$2){
                public static final long serialVersionUID;
                private final DataOutput os$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    if (tuple22 != null) {
                        ((org.fusesource.hawtbuf.Buffer)tuple22._1()).writeTo(this.os$2);
                        this.os$2.write(Stomp$.MODULE$.COLON());
                        ((org.fusesource.hawtbuf.Buffer)tuple22._2()).writeTo(this.os$2);
                        this.os$2.write(Stomp$.MODULE$.NEWLINE());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.os$2 = dataOutput;
                }
            });
            os$2.write(Stomp$.MODULE$.NEWLINE());
            StompContent stompContent = frame.content();
            if (stompContent instanceof ZeroCopyContent) {
                if (StompCodec$.MODULE$.$enable_assertions()) {
                    Predef$.MODULE$.assert(this.next_write_direct() == null);
                }
                this.next_write_direct_$eq(((ZeroCopyContent)stompContent).zero_copy_buffer());
            } else if (stompContent instanceof BufferContent) {
                ((BufferContent)stompContent).content().writeTo(os$2);
                Stomp$.MODULE$.END_OF_FRAME_BUFFER().writeTo(os$2);
            } else {
                Stomp$.MODULE$.END_OF_FRAME_BUFFER().writeTo(os$2);
            }
        }
    }

    public ProtocolCodec.BufferState flush() {
        if (this.write_buffer().remaining() != 0) {
            this.write_counter_$eq(this.write_counter() + (long)this.write_channel().write(this.write_buffer()));
        }
        if (this.write_buffer().remaining() == 0 && this.write_direct() != null) {
            int count = this.write_direct().read(this.write_direct_pos(), this.write_channel());
            this.write_direct_pos_$eq(this.write_direct_pos() + count);
            this.write_counter_$eq(this.write_counter() + (long)count);
            if (this.write_direct().remaining(this.write_direct_pos()) == 0) {
                this.write_direct().release();
                this.write_direct_$eq(null);
                this.write_direct_pos_$eq(0);
                this.write_buffer_$eq(ByteBuffer.wrap(Stomp$.MODULE$.END_OF_FRAME_BUFFER().data));
            }
        }
        if (this.is_empty() && this.write_direct() == null) {
            int prev_size = Predef$.MODULE$.intWrapper(Predef$.MODULE$.intWrapper(this.write_buffer().position() + 512).max(512)).min(this.write_buffer_size());
            this.write_buffer_$eq(this.next_write_buffer().toBuffer().toByteBuffer());
            this.write_direct_$eq(this.next_write_direct());
            this.next_write_buffer_$eq(new DataByteArrayOutputStream(prev_size));
            this.next_write_direct_$eq(null);
        }
        return this.is_empty() ? ProtocolCodec.BufferState.EMPTY : ProtocolCodec.BufferState.NOT_EMPTY;
    }

    public long read_counter() {
        return this.read_counter;
    }

    public void read_counter_$eq(long l) {
        this.read_counter = l;
    }

    public int read_buffer_size() {
        return this.read_buffer_size;
    }

    public void read_buffer_size_$eq(int n) {
        this.read_buffer_size = n;
    }

    public ReadableByteChannel read_channel() {
        return this.read_channel;
    }

    public void read_channel_$eq(ReadableByteChannel readableByteChannel) {
        this.read_channel = readableByteChannel;
    }

    public ByteBuffer read_buffer() {
        return this.read_buffer;
    }

    public void read_buffer_$eq(ByteBuffer byteBuffer) {
        this.read_buffer = byteBuffer;
    }

    public int read_end() {
        return this.read_end;
    }

    public void read_end_$eq(int n) {
        this.read_end = n;
    }

    public int read_start() {
        return this.read_start;
    }

    public void read_start_$eq(int n) {
        this.read_start = n;
    }

    public ZeroCopyBuffer read_direct() {
        return this.read_direct;
    }

    public void read_direct_$eq(ZeroCopyBuffer zeroCopyBuffer) {
        this.read_direct = zeroCopyBuffer;
    }

    public int read_direct_pos() {
        return this.read_direct_pos;
    }

    public void read_direct_pos_$eq(int n) {
        this.read_direct_pos = n;
    }

    public Function1<ByteBuffer, StompFrame> next_action() {
        return this.next_action;
    }

    public void next_action_$eq(Function1<ByteBuffer, StompFrame> function1) {
        this.next_action = function1;
    }

    public boolean trim() {
        return this.trim;
    }

    public void trim_$eq(boolean bl) {
        this.trim = bl;
    }

    public void setReadableByteChannel(ReadableByteChannel channel) {
        this.read_channel_$eq(channel);
        if (this.read_channel() instanceof SocketChannel) {
            this.read_buffer_size_$eq(((SocketChannel)this.read_channel()).socket().getReceiveBufferSize());
        }
    }

    public void unread(org.fusesource.hawtbuf.Buffer buffer) {
        if (StompCodec$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(this.read_counter() == 0L);
        }
        this.read_buffer().put(buffer.data, buffer.offset, buffer.length);
        this.read_counter_$eq(this.read_counter() + (long)buffer.length);
    }

    public long getReadCounter() {
        return this.read_counter();
    }

    public Object read() {
        Object command = null;
        while (command == null) {
            if (this.read_direct() != null && this.read_direct().remaining(this.read_direct_pos()) > 0) {
                int count = this.read_direct().write(this.read_channel(), this.read_direct_pos());
                if (count == -1) {
                    throw new EOFException("Peer disconnected");
                }
                if (count == 0) {
                    return null;
                }
                this.read_direct_pos_$eq(this.read_direct_pos() + count);
            } else if (this.read_end() == this.read_buffer().position()) {
                if (this.read_buffer().remaining() == 0) {
                    int size = this.read_end() - this.read_start();
                    int new_capacity = this.read_start() == 0 ? size + this.read_buffer_size() : (size > this.read_buffer_size() ? size + this.read_buffer_size() : this.read_buffer_size());
                    byte[] new_buffer = new byte[new_capacity];
                    if (size > 0) {
                        System.arraycopy(this.read_buffer().array(), this.read_start(), new_buffer, 0, size);
                    }
                    this.read_buffer_$eq(ByteBuffer.wrap(new_buffer));
                    this.read_buffer().position(size);
                    this.read_start_$eq(0);
                    this.read_end_$eq(size);
                }
                int p = this.read_buffer().position();
                int count = this.read_channel().read(this.read_buffer());
                if (count == -1) {
                    throw new EOFException("Peer disconnected");
                }
                if (count == 0) {
                    return null;
                }
                this.read_counter_$eq(this.read_counter() + (long)count);
            }
            command = this.next_action().apply((Object)this.read_buffer());
            if (StompCodec$.MODULE$.$enable_assertions()) {
                Predef$.MODULE$.assert(this.read_start() <= this.read_end());
            }
            if (!StompCodec$.MODULE$.$enable_assertions()) continue;
            Predef$.MODULE$.assert(this.read_end() <= this.read_buffer().position());
        }
        return command;
    }

    public org.fusesource.hawtbuf.Buffer read_line(ByteBuffer buffer, int max, String errorMessage) {
        int read_limit = buffer.position();
        while (this.read_end() < read_limit) {
            if (buffer.array()[this.read_end()] == 10) {
                org.fusesource.hawtbuf.Buffer rc = new org.fusesource.hawtbuf.Buffer(buffer.array(), this.read_start(), this.read_end() - this.read_start());
                this.read_end_$eq(this.read_end() + 1);
                this.read_start_$eq(this.read_end());
                return rc;
            }
            if (max != -1 && this.read_end() - this.read_start() > max) {
                throw new IOException(errorMessage);
            }
            this.read_end_$eq(this.read_end() + 1);
        }
        return null;
    }

    public Function1<ByteBuffer, StompFrame> read_action() {
        return new Serializable(this){
            public static final long serialVersionUID;
            private final StompCodec $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Null$ apply(ByteBuffer buffer) {
                org.fusesource.hawtbuf.Buffer line = this.$outer.read_line(buffer, StompCodec$.MODULE$.max_command_length(), "The maximum command length was exceeded");
                if (line != null) {
                    org.fusesource.hawtbuf.Buffer action = line;
                    if (this.$outer.trim()) {
                        action = action.trim();
                    }
                    if (action.length() > 0) {
                        this.$outer.next_action_$eq(this.$outer.read_headers(action.ascii(), (ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>>)this.$outer.read_headers$default$2()));
                    }
                }
                return null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public Function1<ByteBuffer, StompFrame> read_headers(AsciiBuffer action$1, ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>> headers$1) {
        return new Serializable(this, action$1, headers$1){
            public static final long serialVersionUID;
            private final StompCodec $outer;
            private final AsciiBuffer action$1;
            private final ListBuffer headers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Loose catch block
             */
            public final StompFrame apply(ByteBuffer buffer) {
                Object object;
                StompFrame rc = null;
                org.fusesource.hawtbuf.Buffer line = this.$outer.read_line(buffer, this.$outer.max_header_length(), "The maximum header length was exceeded");
                if (line == null) {
                    object = BoxedUnit.UNIT;
                } else if (line.trim().length > 0) {
                    if (this.$outer.max_headers() != -1 && this.headers$1.size() > this.$outer.max_headers()) {
                        throw new IOException("The maximum number of headers was exceeded");
                    }
                    boolean exceptionResult2 = false;
                    int seperatorIndex = line.indexOf(Stomp$.MODULE$.COLON());
                    if (seperatorIndex < 0) {
                        throw new IOException(new StringBuilder().append((Object)"Header line missing seperator [").append((Object)org.fusesource.hawtbuf.Buffer.ascii((org.fusesource.hawtbuf.Buffer)line)).append((Object)"]").toString());
                    }
                    org.fusesource.hawtbuf.Buffer name = line.slice(0, seperatorIndex);
                    if (this.$outer.trim()) {
                        name = name.trim();
                    }
                    org.fusesource.hawtbuf.Buffer value = line.slice(seperatorIndex + 1, line.length());
                    if (this.$outer.trim()) {
                        value = value.trim();
                    }
                    exceptionResult2 = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.headers$1).add(new Tuple2((Object)org.fusesource.hawtbuf.Buffer.ascii((org.fusesource.hawtbuf.Buffer)name), (Object)org.fusesource.hawtbuf.Buffer.ascii((org.fusesource.hawtbuf.Buffer)value)));
                    object = BoxesRunTime.boxToBoolean((boolean)exceptionResult2);
                } else {
                    Option<AsciiBuffer> contentLength = this.$outer.get((ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$1, Stomp$.MODULE$.CONTENT_LENGTH());
                    if (contentLength.isDefined()) {
                        int length = 0;
                        length = Integer.parseInt(((org.fusesource.hawtbuf.Buffer)contentLength.get()).trim().toString());
                        if (this.$outer.max_data_length() != -1 && length > this.$outer.max_data_length()) {
                            throw new IOException("The maximum data length was exceeded");
                        }
                        if (length > 1024 && this.$outer.zero_copy_buffer_allocator() != null && this.is_message$1()) {
                            this.$outer.read_direct_$eq(this.$outer.zero_copy_buffer_allocator().alloc(length));
                            ByteBuffer dup = buffer.duplicate();
                            dup.position(this.$outer.read_start());
                            dup.limit(buffer.position());
                            this.$outer.read_direct_pos_$eq(this.$outer.read_direct().write(dup, 0));
                            dup.compact();
                            buffer.position(buffer.position() - this.$outer.read_direct_pos());
                            this.$outer.read_end_$eq(this.$outer.read_start());
                            this.$outer.next_action_$eq(this.$outer.read_binary_body_direct(this.action$1, (ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$1, length));
                        } else {
                            this.$outer.next_action_$eq(this.$outer.read_binary_body(this.action$1, (ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$1, length));
                        }
                    } else {
                        this.$outer.next_action_$eq(this.$outer.read_text_body(this.action$1, (ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$1));
                    }
                    object = BoxedUnit.UNIT;
                }
                return rc;
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IOException(new StringBuilder().append((Object)"Unable to parser header line [").append((Object)line).append((Object)"]").toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Specified content-length is not a valid integer");
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean is_message$1() {
                AsciiBuffer asciiBuffer = this.action$1;
                AsciiBuffer asciiBuffer2 = Stomp$.MODULE$.SEND();
                if (asciiBuffer == null) {
                    if (asciiBuffer2 == null) return true;
                } else if (asciiBuffer.equals(asciiBuffer2)) return true;
                AsciiBuffer asciiBuffer3 = this.action$1;
                AsciiBuffer asciiBuffer4 = Stomp$.MODULE$.MESSAGE();
                if (asciiBuffer3 != null) {
                    if (!asciiBuffer3.equals(asciiBuffer4)) return false;
                    return true;
                }
                if (asciiBuffer4 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.action$1 = asciiBuffer;
                this.headers$1 = listBuffer;
            }
        };
    }

    public ListBuffer read_headers$default$2() {
        return new ListBuffer();
    }

    public Option<AsciiBuffer> get(ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>> headers, AsciiBuffer name) {
        for (Tuple2 entry : headers) {
            Object object = entry._1();
            AsciiBuffer asciiBuffer = name;
            if (object != null ? !object.equals(asciiBuffer) : asciiBuffer != null) continue;
            return new Some(entry._2());
        }
        return None$.MODULE$;
    }

    public Function1<ByteBuffer, StompFrame> read_binary_body_direct(AsciiBuffer action$2, ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>> headers$2, int contentLength$1) {
        return new Serializable(this, action$2, headers$2, contentLength$1){
            public static final long serialVersionUID;
            private final StompCodec $outer;
            private final AsciiBuffer action$2;
            private final ListBuffer headers$2;
            private final int contentLength$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Null$ apply(ByteBuffer buffer) {
                if (this.$outer.read_direct().remaining(this.$outer.read_direct_pos()) == 0) {
                    this.$outer.next_action_$eq(this.$outer.read_direct_terminator(this.action$2, (ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$2, this.contentLength$1, this.$outer.read_direct()));
                    this.$outer.read_direct_$eq(null);
                    this.$outer.read_direct_pos_$eq(0);
                }
                return null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.action$2 = asciiBuffer;
                this.headers$2 = listBuffer;
                this.contentLength$1 = n;
            }
        };
    }

    public Function1<ByteBuffer, StompFrame> read_direct_terminator(AsciiBuffer action$5, ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>> headers$5, int contentLength$3, ZeroCopyBuffer ma$1) {
        return new Serializable(this, action$5, headers$5, contentLength$3, ma$1){
            public static final long serialVersionUID;
            private final StompCodec $outer;
            private final AsciiBuffer action$5;
            private final ListBuffer headers$5;
            private final int contentLength$3;
            private final ZeroCopyBuffer ma$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StompFrame apply(ByteBuffer buffer) {
                StompFrame stompFrame;
                if (this.$outer.read_frame_terminator(buffer, this.contentLength$3)) {
                    this.$outer.next_action_$eq(this.$outer.read_action());
                    stompFrame = new StompFrame(org.fusesource.hawtbuf.Buffer.ascii((org.fusesource.hawtbuf.Buffer)this.action$5), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$5.toList(), new ZeroCopyContent(this.ma$1), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)StompFrame$.MODULE$.init$default$4());
                } else {
                    stompFrame = null;
                }
                return stompFrame;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.action$5 = asciiBuffer;
                this.headers$5 = listBuffer;
                this.contentLength$3 = n;
                this.ma$1 = zeroCopyBuffer;
            }
        };
    }

    public boolean read_frame_terminator(ByteBuffer buffer, int contentLength) {
        boolean bl;
        int read_limit = buffer.position();
        if (read_limit - this.read_start() < 1) {
            this.read_end_$eq(read_limit);
            bl = false;
        } else {
            if (buffer.array()[this.read_start()] != 0) {
                throw new IOException(new StringBuilder().append((Object)"Expected null termintor after ").append((Object)BoxesRunTime.boxToInteger((int)contentLength)).append((Object)" content bytes").toString());
            }
            this.read_end_$eq(this.read_start() + 1);
            this.read_start_$eq(this.read_end());
            bl = true;
        }
        return bl;
    }

    public Function1<ByteBuffer, StompFrame> read_binary_body(AsciiBuffer action$3, ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>> headers$3, int contentLength$2) {
        return new Serializable(this, action$3, headers$3, contentLength$2){
            public static final long serialVersionUID;
            private final StompCodec $outer;
            private final AsciiBuffer action$3;
            private final ListBuffer headers$3;
            private final int contentLength$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StompFrame apply(ByteBuffer buffer) {
                StompFrame stompFrame;
                org.fusesource.hawtbuf.Buffer content = this.$outer.read_content(buffer, this.contentLength$2);
                if (content == null) {
                    stompFrame = null;
                } else {
                    this.$outer.next_action_$eq(this.$outer.read_action());
                    stompFrame = new StompFrame(org.fusesource.hawtbuf.Buffer.ascii((org.fusesource.hawtbuf.Buffer)this.action$3), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$3.toList(), new BufferContent(content), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)StompFrame$.MODULE$.init$default$4());
                }
                return stompFrame;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.action$3 = asciiBuffer;
                this.headers$3 = listBuffer;
                this.contentLength$2 = n;
            }
        };
    }

    public org.fusesource.hawtbuf.Buffer read_content(ByteBuffer buffer, int contentLength) {
        org.fusesource.hawtbuf.Buffer buffer2;
        int read_limit = buffer.position();
        if (read_limit - this.read_start() < contentLength + 1) {
            this.read_end_$eq(read_limit);
            buffer2 = null;
        } else {
            if (buffer.array()[this.read_start() + contentLength] != 0) {
                throw new IOException(new StringBuilder().append((Object)"Expected null termintor after ").append((Object)BoxesRunTime.boxToInteger((int)contentLength)).append((Object)" content bytes").toString());
            }
            org.fusesource.hawtbuf.Buffer rc = new org.fusesource.hawtbuf.Buffer(buffer.array(), this.read_start(), contentLength);
            this.read_end_$eq(this.read_start() + contentLength + 1);
            this.read_start_$eq(this.read_end());
            buffer2 = rc;
        }
        return buffer2;
    }

    public org.fusesource.hawtbuf.Buffer read_to_null(ByteBuffer buffer) {
        int read_limit = buffer.position();
        while (this.read_end() < read_limit) {
            if (buffer.array()[this.read_end()] == 0) {
                org.fusesource.hawtbuf.Buffer rc = new org.fusesource.hawtbuf.Buffer(buffer.array(), this.read_start(), this.read_end() - this.read_start());
                this.read_end_$eq(this.read_end() + 1);
                this.read_start_$eq(this.read_end());
                return rc;
            }
            this.read_end_$eq(this.read_end() + 1);
        }
        return null;
    }

    public Function1<ByteBuffer, StompFrame> read_text_body(AsciiBuffer action$4, ListBuffer<Tuple2<AsciiBuffer, AsciiBuffer>> headers$4) {
        return new Serializable(this, action$4, headers$4){
            public static final long serialVersionUID;
            private final StompCodec $outer;
            private final AsciiBuffer action$4;
            private final ListBuffer headers$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StompFrame apply(ByteBuffer buffer) {
                StompFrame stompFrame;
                org.fusesource.hawtbuf.Buffer content = this.$outer.read_to_null(buffer);
                if (content == null) {
                    stompFrame = null;
                } else {
                    this.$outer.next_action_$eq(this.$outer.read_action());
                    stompFrame = new StompFrame(org.fusesource.hawtbuf.Buffer.ascii((org.fusesource.hawtbuf.Buffer)this.action$4), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)this.headers$4.toList(), new BufferContent(content), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)StompFrame$.MODULE$.init$default$4());
                }
                return stompFrame;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.action$4 = asciiBuffer;
                this.headers$4 = listBuffer;
            }
        };
    }
}

