/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.stomp;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.activemq.apollo.broker.BufferConversions$;
import org.apache.activemq.apollo.broker.store.MessageRecord;
import org.apache.activemq.apollo.stomp.BufferContent;
import org.apache.activemq.apollo.stomp.Stomp$;
import org.apache.activemq.apollo.stomp.StompFrame;
import org.apache.activemq.apollo.stomp.StompFrame$;
import org.apache.activemq.apollo.stomp.StompFrameMessage;
import org.apache.activemq.apollo.stomp.ZeroCopyContent;
import org.apache.activemq.apollo.util.Log;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StompCodec$
implements Log,
ScalaObject {
    public static final StompCodec$ MODULE$;
    private int max_command_length;
    private final boolean $enable_assertions;
    private final Logger log;

    static {
        new StompCodec$();
    }

    public int max_command_length() {
        return this.max_command_length;
    }

    public void max_command_length_$eq(int n) {
        this.max_command_length = n;
    }

    /*
     * WARNING - void declaration
     */
    public MessageRecord encode(StompFrameMessage message) {
        void var3_3;
        StompFrame frame$1 = message.frame();
        MessageRecord rc$1 = new MessageRecord();
        rc$1.protocol_$eq(BufferConversions$.MODULE$.toAsciiBuffer(Stomp$.MODULE$.PROTOCOL()));
        rc$1.size_$eq(frame$1.size());
        rc$1.expiration_$eq(message.expiration());
        if (frame$1.content() instanceof ZeroCopyContent) {
            rc$1.zero_copy_buffer_$eq(((ZeroCopyContent)frame$1.content()).zero_copy_buffer());
        }
        ByteArrayOutputStream os$1 = new ByteArrayOutputStream(this.buffer_size$1(frame$1, rc$1));
        frame$1.action().writeTo((OutputStream)os$1);
        os$1.write((int)Stomp$.MODULE$.NEWLINE());
        if (!frame$1.updated_headers().isEmpty()) {
            ((LinearSeqOptimized)frame$1.updated_headers().filter((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(os$1){
                public static final long serialVersionUID;
                private final ByteArrayOutputStream os$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    if (tuple22 != null) {
                        ((org.fusesource.hawtbuf.Buffer)tuple22._1()).writeTo((OutputStream)this.os$1);
                        this.os$1.write((int)Stomp$.MODULE$.COLON());
                        ((org.fusesource.hawtbuf.Buffer)tuple22._2()).writeTo((OutputStream)this.os$1);
                        this.os$1.write((int)Stomp$.MODULE$.NEWLINE());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.os$1 = byteArrayOutputStream;
                }
            });
        }
        if (frame$1.are_headers_in_content_buffer()) {
            int offset = ((org.fusesource.hawtbuf.Buffer)((Tuple2)frame$1.headers().head())._1()).offset;
            AsciiBuffer buffer1 = (AsciiBuffer)((Tuple2)frame$1.headers().head())._1();
            org.fusesource.hawtbuf.Buffer buffer2 = ((BufferContent)frame$1.content()).content();
            int length = buffer2.offset - buffer1.offset + buffer2.length;
            os$1.write(buffer1.data, offset, length);
        } else {
            ((LinearSeqOptimized)frame$1.headers().filter((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(os$1){
                public static final long serialVersionUID;
                private final ByteArrayOutputStream os$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<AsciiBuffer, AsciiBuffer> tuple2) {
                    Tuple2<AsciiBuffer, AsciiBuffer> tuple22 = tuple2;
                    if (tuple22 != null) {
                        ((org.fusesource.hawtbuf.Buffer)tuple22._1()).writeTo((OutputStream)this.os$1);
                        this.os$1.write((int)Stomp$.MODULE$.COLON());
                        ((org.fusesource.hawtbuf.Buffer)tuple22._2()).writeTo((OutputStream)this.os$1);
                        this.os$1.write((int)Stomp$.MODULE$.NEWLINE());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.os$1 = byteArrayOutputStream;
                }
            });
            os$1.write((int)Stomp$.MODULE$.NEWLINE());
            if (rc$1.zero_copy_buffer() == null) {
                frame$1.content().writeTo((OutputStream)os$1);
            }
        }
        rc$1.buffer_$eq(os$1.toBuffer());
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StompFrameMessage decode(MessageRecord message) {
        StompFrameMessage stompFrameMessage;
        org.fusesource.hawtbuf.Buffer buffer$1 = message.buffer().buffer();
        AsciiBuffer action = this.read_line$1(buffer$1);
        ListBuffer headers = new ListBuffer();
        AsciiBuffer line = this.read_line$1(buffer$1);
        while (line.length() > 0) {
            boolean exceptionResult1 = false;
            try {
                int seperatorIndex = line.indexOf(Stomp$.MODULE$.COLON());
                if (seperatorIndex < 0) {
                    throw new IOException("Header line missing seperator.");
                }
                org.fusesource.hawtbuf.Buffer name = line.slice(0, seperatorIndex);
                org.fusesource.hawtbuf.Buffer value = line.slice(seperatorIndex + 1, line.length);
                exceptionResult1 = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)headers).add(new Tuple2((Object)BufferConversions$.MODULE$.toAsciiBuffer(name), (Object)BufferConversions$.MODULE$.toAsciiBuffer(value)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(new StringBuilder().append((Object)"Unable to parser header line [").append((Object)line).append((Object)"]").toString());
            }
            line = this.read_line$1(buffer$1);
        }
        if (message.zero_copy_buffer() == null) {
            stompFrameMessage = new StompFrameMessage(new StompFrame(action, (List<Tuple2<AsciiBuffer, AsciiBuffer>>)headers.toList(), new BufferContent(buffer$1), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)StompFrame$.MODULE$.init$default$4()));
            return stompFrameMessage;
        }
        stompFrameMessage = new StompFrameMessage(new StompFrame(action, (List<Tuple2<AsciiBuffer, AsciiBuffer>>)headers.toList(), new ZeroCopyContent(message.zero_copy_buffer()), (List<Tuple2<AsciiBuffer, AsciiBuffer>>)StompFrame$.MODULE$.init$default$4()));
        return stompFrameMessage;
    }

    public boolean $enable_assertions() {
        return this.$enable_assertions;
    }

    private final int buffer_size$1(StompFrame stompFrame, MessageRecord messageRecord) {
        return messageRecord.zero_copy_buffer() == null ? stompFrame.size() : stompFrame.size() - (messageRecord.zero_copy_buffer().size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final AsciiBuffer read_line$1(org.fusesource.hawtbuf.Buffer buffer) {
        void var3_3;
        int pos = buffer.indexOf((byte)10);
        if (pos < 0) {
            throw new IOException("expected a new line");
        }
        AsciiBuffer rc = buffer.slice(0, pos).ascii();
        buffer.offset += pos + 1;
        buffer.length -= pos + 1;
        return var3_3;
    }

    private StompCodec$() {
        MODULE$ = this;
        Log.class.$init$((Log)this);
        this.max_command_length = 20;
        this.$enable_assertions = this.getClass().desiredAssertionStatus();
    }
}

