/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import org.springframework.util.concurrent.SuccessCallback;
import reactor.fn.Consumer;
import reactor.rx.Promise;

abstract class AbstractPromiseToListenableFutureAdapter<S, T>
implements ListenableFuture<T> {
    private final Promise<S> promise;
    private final ListenableFutureCallbackRegistry<T> registry = new ListenableFutureCallbackRegistry();

    protected AbstractPromiseToListenableFutureAdapter(Promise<S> promise) {
        Assert.notNull(promise, "Promise must not be null");
        this.promise = promise;
        this.promise.onSuccess(new Consumer<S>(){

            public void accept(S result) {
                Object adapted;
                try {
                    adapted = AbstractPromiseToListenableFutureAdapter.this.adapt(result);
                }
                catch (Throwable ex) {
                    AbstractPromiseToListenableFutureAdapter.this.registry.failure(ex);
                    return;
                }
                AbstractPromiseToListenableFutureAdapter.this.registry.success(adapted);
            }
        });
        this.promise.onError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable ex) {
                AbstractPromiseToListenableFutureAdapter.this.registry.failure(ex);
            }
        });
    }

    @Override
    public T get() throws InterruptedException {
        Object result = this.promise.await();
        return this.adapt(result);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.promise.await(timeout, unit);
        if (!this.promise.isComplete()) {
            throw new TimeoutException();
        }
        return this.adapt(result);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.promise.isComplete();
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.registry.addCallback(callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.registry.addSuccessCallback(successCallback);
        this.registry.addFailureCallback(failureCallback);
    }

    protected abstract T adapt(S var1);
}

