/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.IllegalOptionException;
import org.apache.camel.NoSuchOptionException;
import org.apache.camel.impl.verifier.DefaultResult;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;

public final class ResultBuilder {
    private Optional<ComponentVerifier.Scope> scope = Optional.empty();
    private Optional<ComponentVerifier.Result.Status> status = Optional.empty();
    private List<ComponentVerifier.VerificationError> verificationErrors;

    public ResultBuilder scope(ComponentVerifier.Scope scope) {
        this.scope = Optional.of(scope);
        return this;
    }

    public ResultBuilder status(ComponentVerifier.Result.Status status) {
        this.status = Optional.of(status);
        return this;
    }

    public ResultBuilder error(ComponentVerifier.VerificationError verificationError) {
        if (this.verificationErrors == null) {
            this.verificationErrors = new ArrayList<ComponentVerifier.VerificationError>();
        }
        this.verificationErrors.add(verificationError);
        this.status = Optional.of(ComponentVerifier.Result.Status.ERROR);
        return this;
    }

    public ResultBuilder error(Optional<ComponentVerifier.VerificationError> error) {
        error.ifPresent(e -> this.error((ComponentVerifier.VerificationError)e));
        return this;
    }

    public ResultBuilder error(Supplier<Optional<ComponentVerifier.VerificationError>> supplier) {
        return this.error(supplier.get());
    }

    public ResultBuilder error(ThrowingConsumer<ResultBuilder, Exception> consumer) {
        try {
            consumer.accept(this);
        }
        catch (NoSuchOptionException e) {
            this.error(ResultErrorBuilder.withMissingOption(e.getOptionName()).build());
        }
        catch (IllegalOptionException e) {
            this.error(ResultErrorBuilder.withIllegalOption(e.getOptionName(), e.getOptionValue()).build());
        }
        catch (Exception e) {
            this.error(ResultErrorBuilder.withException(e).build());
        }
        return this;
    }

    public <T> ResultBuilder error(T data, ThrowingBiConsumer<ResultBuilder, T, Exception> consumer) {
        try {
            consumer.accept(this, data);
        }
        catch (NoSuchOptionException e) {
            this.error(ResultErrorBuilder.withMissingOption(e.getOptionName()).build());
        }
        catch (IllegalOptionException e) {
            this.error(ResultErrorBuilder.withIllegalOption(e.getOptionName(), e.getOptionValue()).build());
        }
        catch (Exception e) {
            this.error(ResultErrorBuilder.withException(e).build());
        }
        return this;
    }

    public ResultBuilder errors(List<ComponentVerifier.VerificationError> verificationErrors) {
        verificationErrors.forEach(this::error);
        return this;
    }

    public ComponentVerifier.Result build() {
        return new DefaultResult(this.scope.orElse(ComponentVerifier.Scope.PARAMETERS), this.status.orElse(ComponentVerifier.Result.Status.UNSUPPORTED), this.verificationErrors != null ? Collections.unmodifiableList(this.verificationErrors) : Collections.emptyList());
    }

    public static ResultBuilder withStatus(ComponentVerifier.Result.Status status) {
        return new ResultBuilder().status(status);
    }

    public static ResultBuilder withStatusAndScope(ComponentVerifier.Result.Status status, ComponentVerifier.Scope scope) {
        return new ResultBuilder().status(status).scope(scope);
    }

    public static ResultBuilder withScope(ComponentVerifier.Scope scope) {
        return new ResultBuilder().scope(scope);
    }

    public static ResultBuilder unsupported() {
        return ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.UNSUPPORTED, ComponentVerifier.Scope.PARAMETERS);
    }

    public static ResultBuilder unsupportedScope(ComponentVerifier.Scope scope) {
        return ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.UNSUPPORTED, scope);
    }
}

