/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.net.URI;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoBrokerTempQueueAdvisoryTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TwoBrokerTempQueueAdvisoryTest.class);
    public boolean useDuplex = true;

    private void sendReceiveTempQueueMessage(String broker) throws Exception {
        ConnectionFactory factory = this.getConnectionFactory(broker);
        Connection conn = factory.createConnection();
        Session session = conn.createSession(false, 1);
        session.createTemporaryQueue();
        conn.close();
    }

    public void testTemporaryQueueAdvisory() throws Exception {
        LOG.info("Running testTemporaryQueueAdvisory()");
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        this.waitForMinTopicRegionConsumerCount("BrokerB", 1);
        this.waitForMinTopicRegionConsumerCount("BrokerA", 1);
        int iterations = 30;
        for (int i = 0; i < 30; ++i) {
            this.sendReceiveTempQueueMessage("BrokerA");
        }
        this.waitForMinTopicRegionConsumerCount("BrokerB", 1);
        this.waitForMinTopicRegionConsumerCount("BrokerA", 1);
        final DestinationViewMBean brokerAView = this.createView("BrokerA", "ActiveMQ.Advisory.TempQueue", (byte)2);
        TwoBrokerTempQueueAdvisoryTest.assertTrue((String)"exact amount of advisories created on A, one each for creation/deletion", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("BrokerA temp advisory enque count: " + brokerAView.getEnqueueCount());
                return 60L == brokerAView.getEnqueueCount();
            }
        }));
        final DestinationViewMBean brokerBView = this.createView("BrokerB", "ActiveMQ.Advisory.TempQueue", (byte)2);
        TwoBrokerTempQueueAdvisoryTest.assertTrue((String)"exact amount of advisories created on B, one each for creation/deletion", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("BrokerB temp advisory enque count: " + brokerBView.getEnqueueCount());
                return 60L == brokerBView.getEnqueueCount();
            }
        }));
    }

    public void initCombosForTestSendToRemovedTemp() {
        this.addCombinationValues("useDuplex", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
    }

    public void testSendToRemovedTemp() throws Exception {
        ActiveMQQueue requestReplyDest = new ActiveMQQueue("RequestReply");
        NetworkConnector nc = this.bridgeBrokers("BrokerA", "BrokerB");
        if (this.useDuplex) {
            nc.setDuplex(true);
        } else {
            this.bridgeBrokers("BrokerB", "BrokerA");
        }
        if (!this.useDuplex) {
            ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerB")).broker.setAllowTempAutoCreationOnSend(true);
        }
        TransportConnector forClient = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker.addConnector("tcp://localhost:0");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        this.waitForMinTopicRegionConsumerCount("BrokerB", 1);
        this.waitForMinTopicRegionConsumerCount("BrokerA", 1);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(forClient.getConnectUri());
        ActiveMQConnection conn = (ActiveMQConnection)factory.createConnection();
        conn.setWatchTopicAdvisories(false);
        conn.start();
        Session session = conn.createSession(false, 1);
        ConnectionFactory replyFactory = this.getConnectionFactory("BrokerB");
        for (int i = 0; i < 500; ++i) {
            TemporaryQueue tempDest = session.createTemporaryQueue();
            MessageProducer producer = session.createProducer((Destination)requestReplyDest);
            TextMessage message = session.createTextMessage("req-" + i);
            message.setJMSReplyTo((Destination)tempDest);
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)tempDest);
            producer.send((Message)message);
            ActiveMQConnection replyConnection = (ActiveMQConnection)replyFactory.createConnection();
            replyConnection.setWatchTopicAdvisories(false);
            replyConnection.start();
            Session replySession = replyConnection.createSession(false, 1);
            ActiveMQMessageConsumer replyConsumer = (ActiveMQMessageConsumer)replySession.createConsumer((Destination)requestReplyDest);
            Message msg = replyConsumer.receive(10000L);
            TwoBrokerTempQueueAdvisoryTest.assertNotNull((String)("request message not null: " + i), (Object)msg);
            MessageProducer replyProducer = replySession.createProducer(msg.getJMSReplyTo());
            replyProducer.send((Message)session.createTextMessage("reply-" + i));
            replyConnection.close();
            Message reply = consumer.receive(10000L);
            TwoBrokerTempQueueAdvisoryTest.assertNotNull((String)("reply message : " + i + ", to: " + String.valueOf(tempDest) + ", by consumer:" + String.valueOf(consumer.getConsumerId())), (Object)reply);
            consumer.close();
            tempDest.delete();
        }
    }

    protected DestinationViewMBean createView(String broker, String destination, byte type) throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = type == 1 ? new ObjectName(domain + ":type=Broker,brokerName=" + broker + ",destinationType=Queue,destinationName=" + destination) : new ObjectName(domain + ":type=Broker,brokerName=" + broker + ",destinationType=Topic,destinationName=" + destination);
        return (DestinationViewMBean)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)broker)).broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = new String("?persistent=false");
        this.createBroker(new URI("broker:(tcp://localhost:0)/BrokerA" + options));
        this.createBroker(new URI("broker:(tcp://localhost:0)/BrokerB" + options));
    }

    public static Test suite() {
        return TwoBrokerTempQueueAdvisoryTest.suite(TwoBrokerTempQueueAdvisoryTest.class);
    }
}

