/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.Assert;

public class TopicSubscriptionSlowConsumerTest
extends TestCase {
    private static final String TOPIC_NAME = "slow.consumer";
    Connection connection;
    private Session session;
    private ActiveMQTopic destination;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private BrokerService brokerService;

    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        activeMQConnectionFactory.setWatchTopicAdvisories(true);
        this.connection = activeMQConnectionFactory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.destination = new ActiveMQTopic(TOPIC_NAME);
        this.producer = this.session.createProducer((Destination)this.destination);
        this.connection.start();
    }

    public void testPrefetchValueOne() throws Exception {
        int i;
        ActiveMQTopic consumerDestination = new ActiveMQTopic("slow.consumer?consumer.prefetchSize=1");
        this.consumer = this.session.createConsumer((Destination)consumerDestination);
        ActiveMQTopic slowConsumerAdvisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)this.destination);
        MessageConsumer slowConsumerAdvisory = this.session.createConsumer((Destination)slowConsumerAdvisoryTopic);
        TextMessage txtMessage = this.session.createTextMessage("Sample Text Message");
        for (i = 0; i < 2; ++i) {
            this.producer.send((Message)txtMessage);
        }
        for (i = 0; i < 2; ++i) {
            Message receivedMsg = this.consumer.receive(100L);
            Assert.assertNotNull((String)("received msg " + i + " should not be null"), (Object)receivedMsg);
        }
        Message slowAdvisoryMessage = slowConsumerAdvisory.receive(100L);
        Assert.assertNull((String)"should not have received a slow consumer advisory message", (Object)slowAdvisoryMessage);
    }

    public void tearDown() throws Exception {
        this.consumer.close();
        this.producer.close();
        this.session.close();
        this.connection.close();
        this.brokerService.stop();
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("localhost");
        broker.setUseJmx(true);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector("vm://localhost");
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setAdvisoryForSlowConsumers(true);
        policyMap.setDefaultEntry(defaultEntry);
        broker.setDestinationPolicy(policyMap);
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }
}

