/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;

public class DurableUnsubscribeTest
extends TestSupport {
    private BrokerService broker;
    private Connection connection;
    private ActiveMQTopic topic;

    public void testUnsubscribe() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        session.close();
        org.apache.activemq.broker.region.Destination d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableUnsubscribeTest.assertEquals((String)"Subscription is missing.", (int)1, (int)d.getConsumers().size());
        session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.topic);
        for (int i = 0; i < 1000; ++i) {
            producer.send((Message)session.createTextMessage("text"));
        }
        Thread.sleep(1000L);
        session.unsubscribe("SubsId");
        session.close();
        DurableUnsubscribeTest.assertEquals((String)"Subscription exists.", (int)0, (int)d.getConsumers().size());
    }

    public void testDestroy() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId2");
        session.close();
        this.connection.close();
        this.connection = null;
        Thread.sleep(1000L);
        org.apache.activemq.broker.region.Destination d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableUnsubscribeTest.assertEquals((String)"Subscription is missing.", (int)1, (int)d.getConsumers().size());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName[] subNames = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        mbs.invoke(subNames[0], "destroy", new Object[0], new String[0]);
        DurableUnsubscribeTest.assertEquals((String)"Subscription exists.", (int)0, (int)d.getConsumers().size());
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName());
    }

    @Override
    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        return rc;
    }

    protected void setUp() throws Exception {
        this.topic = (ActiveMQTopic)this.createDestination();
        this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    private void createBroker() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setUseJmx(true);
        this.broker.setBrokerName(this.getName());
        this.broker.deleteAllMessages();
        this.broker.start();
        this.connection = this.createConnection();
    }

    private void destroyBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }
}

