/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class CompositeMessageCursorUsageTest
extends TestCase {
    BrokerService broker;

    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
    }

    public void testCompositeMessageUsage() throws Exception {
        String compositeQueue = "compositeA,compositeB";
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        JmsTemplate jt = new JmsTemplate((ConnectionFactory)cf);
        jt.send(compositeQueue, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage tm = session.createTextMessage();
                tm.setText("test");
                return tm;
            }
        });
        jt.send("noCompositeA", new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage tm = session.createTextMessage();
                tm.setText("test");
                return tm;
            }
        });
        jt.send("noCompositeB", new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage tm = session.createTextMessage();
                tm.setText("test");
                return tm;
            }
        });
        CompositeMessageCursorUsageTest.assertEquals((String)"Cursor memory usage wrong for 'noCompositeA' queue", (long)1032L, (long)this.getQueueView("noCompositeA").getCursorMemoryUsage());
        CompositeMessageCursorUsageTest.assertEquals((String)"Cursor memory usage wrong for 'noCompositeB' queue", (long)1032L, (long)this.getQueueView("noCompositeB").getCursorMemoryUsage());
        CompositeMessageCursorUsageTest.assertEquals((String)"Cursor memory usage wrong for 'CompositeA' queue", (long)1032L, (long)this.getQueueView("compositeA").getCursorMemoryUsage());
        CompositeMessageCursorUsageTest.assertEquals((String)"Cursor memory usage wrong for 'CompositeB' queue", (long)1032L, (long)this.getQueueView("compositeB").getCursorMemoryUsage());
    }

    public QueueViewMBean getQueueView(String queueName) throws Exception {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queueName);
        return (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
    }
}

