/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.net.Socket;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransportCloseSocketNoWarnTest {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportCloseSocketNoWarnTest.class);
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    public static final Appender appender;
    public static final AtomicBoolean gotExceptionInLog;
    private BrokerService brokerService;
    private org.apache.logging.log4j.core.Logger rootLogger;

    @Before
    public void before() throws Exception {
        gotExceptionInLog.set(false);
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.rootLogger = (org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getRootLogger());
        this.rootLogger.get().addAppender(appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        this.rootLogger.addAppender(appender);
        Configurator.setLevel((String)(TransportConnection.class.getName() + ".Transport"), (Level)Level.WARN);
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
        this.rootLogger.removeAppender(appender);
    }

    @Test(timeout=60000L)
    public void testNoWarn() throws Exception {
        this.doTest(false);
    }

    @Test(timeout=60000L)
    public void testWarn() throws Exception {
        this.doTest(true);
    }

    protected void doTest(boolean warn) throws Exception {
        for (String protocol : new String[]{"tcp", "ssl", "stomp"}) {
            TransportConnector transportConnector = this.brokerService.addConnector(protocol + "://localhost:0");
            transportConnector.setWarnOnRemoteClose(warn);
        }
        this.brokerService = this.brokerService;
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        for (TransportConnector transportConnector : this.brokerService.getTransportConnectors()) {
            Socket socket;
            URI uri = transportConnector.getPublishableConnectURI();
            if (uri.getScheme().equals("ssl")) {
                SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket("127.0.0.1", uri.getPort());
                final CountDownLatch doneHandShake = new CountDownLatch(1);
                sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                    @Override
                    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        doneHandShake.countDown();
                    }
                });
                sslSocket.startHandshake();
                Assert.assertTrue((String)"handshake done", (boolean)doneHandShake.await(10L, TimeUnit.SECONDS));
                socket = sslSocket;
            } else {
                socket = new Socket("127.0.0.1", uri.getPort());
            }
            TimeUnit.SECONDS.sleep(1L);
            LOG.info("testing socket: " + String.valueOf(socket));
            socket.close();
        }
        Assert.assertEquals((String)"warn|no warn in log", (Object)warn, (Object)gotExceptionInLog.get());
    }

    static {
        gotExceptionInLog = new AtomicBoolean();
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getLevel().equals((Object)Level.WARN) && event.getMessage().getFormattedMessage().contains("failed:")) {
                    gotExceptionInLog.set(Boolean.TRUE);
                    LOG.error("got event: " + String.valueOf(event) + ", ex:" + event.getMessage().getFormattedMessage());
                    LOG.error("Event source: ", new Throwable("Here"));
                }
            }
        };
        appender.start();
    }
}

