/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NIOSSLBasicTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    public static final String TRUST_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    public static final int MESSAGE_COUNT = 1000;

    @Before
    public void before() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }

    @After
    public void after() throws Exception {
    }

    public BrokerService createBroker(String connectorName, String connectorString) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        TransportConnector connector = broker.addConnector(connectorString);
        connector.setName(connectorName);
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    public void stopBroker(BrokerService broker) throws Exception {
        if (broker != null) {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    @Test
    public void basicConnector() throws Exception {
        BrokerService broker = this.createBroker("nio+ssl", this.getTransportType() + "://localhost:0?transport.needClientAuth=true");
        this.basicSendReceive("ssl://localhost:" + broker.getConnectorByName("nio+ssl").getConnectUri().getPort() + "?socket.verifyHostName=false");
        this.stopBroker(broker);
    }

    @Test
    public void enabledCipherSuites() throws Exception {
        BrokerService broker = this.createBroker("nio+ssl", this.getTransportType() + "://localhost:0?transport.needClientAuth=true&transport.verifyHostName=false&transport.enabledCipherSuites=TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        this.basicSendReceive("ssl://localhost:" + broker.getConnectorByName("nio+ssl").getConnectUri().getPort() + "?socket.verifyHostName=false");
        this.stopBroker(broker);
    }

    @Test
    public void enabledProtocols() throws Exception {
        BrokerService broker = this.createBroker("nio+ssl", this.getTransportType() + "://localhost:61616?transport.needClientAuth=true&transport.enabledProtocols=TLSv1,TLSv1.1,TLSv1.2");
        this.basicSendReceive("ssl://localhost:" + broker.getConnectorByName("nio+ssl").getConnectUri().getPort() + "?socket.verifyHostName=false");
        this.stopBroker(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=Exception.class)
    public void verifyHostNameErrorClient() throws Exception {
        final CountDownLatch gotLogMessage = new CountDownLatch(1);
        final AtomicBoolean gotRemoteAddressInLog = new AtomicBoolean();
        Logger logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getLevel().equals((Object)Level.WARN) && event.getMessage().getFormattedMessage().contains("Could not accept connection")) {
                    gotLogMessage.countDown();
                    if (event.getMessage().getFormattedMessage().contains("tcp")) {
                        gotRemoteAddressInLog.set(true);
                    }
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        BrokerService broker = null;
        try {
            broker = this.createBroker("nio+ssl", this.getTransportType() + "://localhost:61616?transport.needClientAuth=true");
            this.basicSendReceive("ssl://localhost:" + broker.getConnectorByName("nio+ssl").getConnectUri().getPort());
        }
        finally {
            gotLogMessage.await(5L, TimeUnit.SECONDS);
            if (broker != null) {
                this.stopBroker(broker);
            }
            logger.removeAppender((Appender)appender);
            TestCase.assertTrue((String)"Got remote address in log", (boolean)gotRemoteAddressInLog.get());
        }
    }

    public void basicSendReceive(String uri) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        connection.start();
        String body = "hello world!";
        Queue destination = session.createQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage(body));
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message received = consumer.receive(2000L);
        TestCase.assertEquals((String)body, (String)((TextMessage)received).getText());
    }

    protected String getTransportType() {
        return "nio+ssl";
    }
}

