/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

public class NIOMaxFrameSizeCleanupTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    public static final String TRUST_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    private BrokerService broker;

    @BeforeClass
    public static void beforeClass() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }

    @After
    public void after() throws Exception {
        this.stopBroker(this.broker);
    }

    public BrokerService createBroker(String connectorName, String connectorString) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        TransportConnector connector = broker.addConnector(connectorString);
        connector.setName(connectorName);
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    public void stopBroker(BrokerService broker) throws Exception {
        if (broker != null) {
            broker.stop();
            broker.waitUntilStopped();
        }
    }

    @Test
    public void testMaxFrameSizeCleanupNio() throws Exception {
        String transportType = "nio";
        this.broker = this.createBroker(transportType, transportType + "://localhost:0?wireFormat.maxFrameSize=1024");
        this.testMaxFrameSizeCleanup(transportType, "tcp://localhost:" + this.broker.getConnectorByName(transportType).getConnectUri().getPort() + "?wireFormat.maxFrameSizeEnabled=false");
    }

    @Test
    public void testMaxFrameSizeCleanupAutoNio() throws Exception {
        String transportType = "auto+nio";
        this.broker = this.createBroker(transportType, transportType + "://localhost:0?wireFormat.maxFrameSize=1024");
        this.testMaxFrameSizeCleanup(transportType, "tcp://localhost:" + this.broker.getConnectorByName(transportType).getConnectUri().getPort() + "?wireFormat.maxFrameSizeEnabled=false");
    }

    @Test
    public void testMaxFrameSizeCleanupNioSsl() throws Exception {
        String transportType = "nio+ssl";
        this.broker = this.createBroker(transportType, transportType + "://localhost:0?transport.needClientAuth=true&wireFormat.maxFrameSize=1024");
        this.testMaxFrameSizeCleanup(transportType, "ssl://localhost:" + this.broker.getConnectorByName(transportType).getConnectUri().getPort() + "?socket.verifyHostName=false&wireFormat.maxFrameSizeEnabled=false");
    }

    @Test
    public void testMaxFrameSizeCleanupAutoNioSsl() throws Exception {
        String transportType = "auto+nio+ssl";
        this.broker = this.createBroker(transportType, transportType + "://localhost:0?transport.needClientAuth=true&wireFormat.maxFrameSize=1024");
        this.testMaxFrameSizeCleanup(transportType, "ssl://localhost:" + this.broker.getConnectorByName(transportType).getConnectUri().getPort() + "?socket.verifyHostName=false&wireFormat.maxFrameSizeEnabled=false");
    }

    protected void testMaxFrameSizeCleanup(String transportType, String clientUri) throws Exception {
        int i;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(clientUri);
        for (int i2 = 0; i2 < 10; ++i2) {
            Connection connection = factory.createConnection();
            connection.start();
            connections.add(connection);
        }
        StringBuffer body = new StringBuffer();
        Random r = new Random();
        for (i = 0; i < 10000; ++i) {
            body.append(r.nextInt());
        }
        for (i = 0; i < 10; ++i) {
            boolean exception = false;
            try {
                Connection connection = (Connection)connections.get(i);
                Session session = connection.createSession(false, 1);
                Queue destination = session.createQueue("TEST");
                MessageProducer producer = session.createProducer((Destination)destination);
                producer.send((Message)session.createTextMessage(body.toString()));
            }
            catch (Exception e) {
                exception = true;
            }
            TestCase.assertTrue((String)"Should have gotten a transport exception", (boolean)exception);
        }
        ThreadPoolExecutor e = (ThreadPoolExecutor)SelectorManager.getInstance().getSelectorExecutor();
        TestCase.assertTrue((boolean)Wait.waitFor(() -> this.broker.getConnectorByName(transportType).getConnections().size() == 0, (long)5000L, (long)500L));
        TestCase.assertTrue((boolean)Wait.waitFor(() -> e.getActiveCount() == 0, (long)5000L, (long)500L));
    }
}

