/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.junit.Assert;
import org.junit.Test;

public class FailoverTransportUriHandlingTest {
    @Test
    public void testFailoverTransportAddWithInitialUnknown() throws Exception {
        String[] uriArray;
        FailoverTransport transport = new FailoverTransport();
        String initialUri = "tcp://no.existing.hostname:61616";
        transport.add(false, "tcp://no.existing.hostname:61616");
        for (String uri : uriArray = new String[]{"tcp://127.0.0.2:61616", "tcp://localhost:61616", "tcp://localhost:61617"}) {
            transport.add(false, uri);
        }
        Collection<URI> uris = this.getRegisteredUrlsFromPrivateField(transport);
        for (String uri : uriArray) {
            Assert.assertTrue((String)("Collection should contain: " + uri), (boolean)uris.contains(new URI(uri)));
        }
    }

    @Test
    public void testFailoverTransportAddWithInitialKnown() throws Exception {
        String[] uriArray;
        FailoverTransport transport = new FailoverTransport();
        String initialUri = "tcp://localhost:61616";
        transport.add(false, "tcp://localhost:61616");
        for (String uri : uriArray = new String[]{"tcp://127.0.0.2:61616", "tcp://no.existing.hostname:61616", "tcp://localhost:61617"}) {
            transport.add(false, uri);
        }
        Collection<URI> uris = this.getRegisteredUrlsFromPrivateField(transport);
        for (String uri : uriArray) {
            Assert.assertTrue((String)("Collection should contain: " + uri), (boolean)uris.contains(new URI(uri)));
        }
    }

    @Test
    public void testFailoverTransportAddWithPreventsDups() throws Exception {
        String[] uriArray;
        FailoverTransport transport = new FailoverTransport();
        String initialUri = "tcp://localhost:61616";
        transport.add(false, "tcp://localhost:61616");
        for (String uri : uriArray = new String[]{"tcp://127.0.0.2:61616", "tcp://localhost:61616", "tcp://no.existing.hostname:61616", "tcp://localhost:61617", "tcp://127.0.0.1:61616"}) {
            transport.add(false, uri);
        }
        Collection<URI> uris = this.getRegisteredUrlsFromPrivateField(transport);
        Assert.assertEquals((long)4L, (long)uris.size());
        transport.add(false, "tcp://no.existing.hostname:61616");
        uris = this.getRegisteredUrlsFromPrivateField(transport);
        Assert.assertEquals((long)4L, (long)uris.size());
    }

    @Test
    public void testFailoverTransportAddArray() throws Exception {
        FailoverTransport transport = new FailoverTransport();
        String initialUri = "tcp://no.existing.hostname:61616";
        transport.add(false, "tcp://no.existing.hostname:61616");
        URI[] uriArray = new URI[]{new URI("tcp://127.0.0.2:61616"), new URI("tcp://localhost:61616"), new URI("tcp://localhost:61617")};
        transport.add(false, uriArray);
        Collection<URI> uris = this.getRegisteredUrlsFromPrivateField(transport);
        for (URI uri : uriArray) {
            Assert.assertTrue((String)("Collection should contain: " + String.valueOf(uri)), (boolean)uris.contains(uri));
        }
        Assert.assertEquals((long)4L, (long)uris.size());
        transport.add(false, "tcp://no.existing.hostname:61616");
        uris = this.getRegisteredUrlsFromPrivateField(transport);
        Assert.assertEquals((long)4L, (long)uris.size());
        transport.add(false, uriArray);
        Assert.assertEquals((long)4L, (long)uris.size());
    }

    private Collection<URI> getRegisteredUrlsFromPrivateField(FailoverTransport failoverTransport) throws SecurityException, NoSuchFieldException, IllegalAccessException {
        Field urisField = failoverTransport.getClass().getDeclaredField("uris");
        urisField.setAccessible(true);
        return (Collection)urisField.get(failoverTransport);
    }
}

