/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Vector;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.StubCompositeTransport;
import org.apache.activemq.transport.discovery.DiscoveryTransport;
import org.apache.activemq.transport.discovery.DiscoveryTransportFactory;
import org.apache.activemq.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTransportNoBrokerTest
extends CombinationTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryTransportNoBrokerTest.class);

    public void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    public void testNoExtraThreads() throws Exception {
        Thread[] threads;
        BrokerService broker = new BrokerService();
        TransportConnector tcp = broker.addConnector("tcp://localhost:0?transport.closeAsync=false");
        String group = "GR-" + System.currentTimeMillis();
        URI discoveryUri = new URI("multicast://default?group=" + group);
        tcp.setDiscoveryUri(discoveryUri);
        broker.start();
        broker.waitUntilStarted();
        Vector<String> existingNames = new Vector<String>();
        for (Thread t : threads = this.getThreads()) {
            existingNames.add(t.getName());
        }
        int idleThreadCount = threads.length;
        LOG.info("Broker started - thread Count:" + idleThreadCount);
        int noConnectionToCreate = 10;
        for (int i = 0; i < 10; ++i) {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("discovery:(multicast://239.255.2.3:6155?group=" + group + ")?closeAsync=false&startupMaxReconnectAttempts=10&initialReconnectDelay=1000");
            LOG.info("Connecting.");
            Connection connection = factory.createConnection();
            connection.setClientID("test");
            connection.close();
        }
        Thread.sleep(2000L);
        for (Thread t : threads = this.getThreads()) {
            if (existingNames.contains(t.getName())) continue;
            LOG.info("Remaining thread:" + String.valueOf(t));
        }
        DiscoveryTransportNoBrokerTest.assertTrue((String)"no extra threads per connection", (Thread.activeCount() - idleThreadCount < 10 ? 1 : 0) != 0);
    }

    private Thread[] getThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        return threads;
    }

    public void testMaxReconnectAttempts() throws JMSException {
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("discovery:(multicast://doesNOTexist)");
            LOG.info("Connecting.");
            Connection connection = factory.createConnection();
            connection.setClientID("test");
            DiscoveryTransportNoBrokerTest.fail((String)"Did not fail to connect as expected.");
        }
        catch (JMSException expected) {
            DiscoveryTransportNoBrokerTest.assertTrue((String)("reason is java.io.IOException, was: " + String.valueOf(expected.getCause())), (boolean)(expected.getCause() instanceof IOException));
        }
    }

    public void testInitialConnectDelayWithNoBroker() throws Exception {
        long initialReconnectDelay = 4000L;
        long startT = System.currentTimeMillis();
        String groupId = "WillNotMatch" + startT;
        try {
            String urlStr = "discovery:(multicast://default?group=" + groupId + ")?useExponentialBackOff=false&maxReconnectAttempts=2&reconnectDelay=" + initialReconnectDelay;
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(urlStr);
            LOG.info("Connecting.");
            Connection connection = factory.createConnection();
            connection.setClientID("test");
            DiscoveryTransportNoBrokerTest.fail((String)"Did not fail to connect as expected.");
        }
        catch (JMSException expected) {
            DiscoveryTransportNoBrokerTest.assertTrue((String)("reason is java.io.IOException, was: " + String.valueOf(expected.getCause())), (boolean)(expected.getCause() instanceof IOException));
            long duration = System.currentTimeMillis() - startT;
            DiscoveryTransportNoBrokerTest.assertTrue((String)("took at least initialReconnectDelay time: " + duration + " e:" + String.valueOf((Object)expected)), (duration >= initialReconnectDelay ? 1 : 0) != 0);
        }
    }

    public void testSetDiscoveredBrokerProperties() throws Exception {
        String extraParameterName = "connectionTimeout";
        String extraParameterValue = "3000";
        URI uri = new URI("discovery:(multicast://default)?initialReconnectDelay=100&discovered.connectionTimeout=3000");
        URISupport.CompositeData compositeData = URISupport.parseComposite((URI)uri);
        StubCompositeTransport compositeTransport = new StubCompositeTransport();
        DiscoveryTransport discoveryTransport = DiscoveryTransportFactory.createTransport((CompositeTransport)compositeTransport, (URISupport.CompositeData)compositeData, (Map)compositeData.getParameters());
        discoveryTransport.onServiceAdd(new DiscoveryEvent("tcp://localhost:61616"));
        DiscoveryTransportNoBrokerTest.assertEquals((String)"expected added URI after discovery event", (int)compositeTransport.getTransportURIs().length, (int)1);
        URI discoveredServiceURI = compositeTransport.getTransportURIs()[0];
        Map parameters = URISupport.parseParameters((URI)discoveredServiceURI);
        DiscoveryTransportNoBrokerTest.assertTrue((String)"unable to add parameter to discovered service", (boolean)parameters.containsKey("connectionTimeout"));
        DiscoveryTransportNoBrokerTest.assertEquals((String)"incorrect value for parameter added to discovered service", (String)((String)parameters.get("connectionTimeout")), (String)"3000");
    }

    public void testSetDiscoveredStaticBrokerProperties() throws Exception {
        String extraParameterName = "connectionTimeout";
        String extraParameterValue = "3000";
        URI uri = new URI("discovery:(static:tcp://localhost:61616)?initialReconnectDelay=100&discovered.connectionTimeout=3000");
        URISupport.CompositeData compositeData = URISupport.parseComposite((URI)uri);
        StubCompositeTransport compositeTransport = new StubCompositeTransport();
        DiscoveryTransport discoveryTransport = DiscoveryTransportFactory.createTransport((CompositeTransport)compositeTransport, (URISupport.CompositeData)compositeData, (Map)compositeData.getParameters());
        discoveryTransport.start();
        DiscoveryTransportNoBrokerTest.assertEquals((String)"expected added URI after discovery event", (int)1, (int)compositeTransport.getTransportURIs().length);
        URI discoveredServiceURI = compositeTransport.getTransportURIs()[0];
        Map parameters = URISupport.parseParameters((URI)discoveredServiceURI);
        DiscoveryTransportNoBrokerTest.assertTrue((String)"unable to add parameter to discovered service", (boolean)parameters.containsKey("connectionTimeout"));
        DiscoveryTransportNoBrokerTest.assertEquals((String)"incorrect value for parameter added to discovered service", (String)((String)parameters.get("connectionTimeout")), (String)"3000");
    }

    public void testAddRemoveDiscoveredBroker() throws Exception {
        URI uri = new URI("discovery:(multicast://default)?initialReconnectDelay=100&connectionTimeout=3000");
        URISupport.CompositeData compositeData = URISupport.parseComposite((URI)uri);
        StubCompositeTransport compositeTransport = new StubCompositeTransport();
        DiscoveryTransport discoveryTransport = DiscoveryTransportFactory.createTransport((CompositeTransport)compositeTransport, (URISupport.CompositeData)compositeData, (Map)compositeData.getParameters());
        String serviceName = "tcp://localhost:61616";
        discoveryTransport.onServiceAdd(new DiscoveryEvent("tcp://localhost:61616"));
        DiscoveryTransportNoBrokerTest.assertEquals((String)"expected added URI after discovery event", (int)1, (int)compositeTransport.getTransportURIs().length);
        discoveryTransport.onServiceRemove(new DiscoveryEvent("tcp://localhost:61616"));
        DiscoveryTransportNoBrokerTest.assertEquals((String)"expected URI removed after discovery event", (int)0, (int)compositeTransport.getTransportURIs().length);
    }
}

