/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.retroactive;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import java.util.Date;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.MessageIdList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetroactiveConsumerWithMessageQueryTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RetroactiveConsumerWithMessageQueryTest.class);
    protected int messageCount = 20;
    protected Connection connection;
    protected Session session;

    public void testConsumeAndReceiveInitialQueryBeforeUpdates() throws Exception {
        this.connection = this.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.destination);
        MessageIdList listener = new MessageIdList();
        listener.setVerbose(true);
        consumer.setMessageListener((MessageListener)listener);
        MessageProducer producer = this.session.createProducer((Destination)this.destination);
        int updateMessageCount = this.messageCount - 10;
        for (int i = 0; i < updateMessageCount; ++i) {
            TextMessage message = this.session.createTextMessage("Update Message: " + i + " sent at: " + String.valueOf(new Date()));
            producer.send((Message)message);
        }
        producer.close();
        LOG.info("Sent: " + updateMessageCount + " update messages");
        listener.assertMessagesReceived(this.messageCount);
    }

    @Override
    protected void setUp() throws Exception {
        this.useTopic = true;
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory(this.bindAddress);
        return answer;
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        String uri = this.getBrokerXml();
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    @Override
    protected void startBroker() throws Exception {
    }

    protected String getBrokerXml() {
        return "org/apache/activemq/test/retroactive/activemq-message-query.xml";
    }
}

