/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.message;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedMapAndListPropertyTest
extends JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest {
    private static final Logger LOG = LoggerFactory.getLogger(NestedMapAndListPropertyTest.class);

    @Override
    protected void assertMessageValid(int index, Message message) throws JMSException {
        Object value = message.getObjectProperty("textField");
        NestedMapAndListPropertyTest.assertEquals((String)"textField", (Object)this.data[index], (Object)value);
        Map map = (Map)message.getObjectProperty("mapField");
        NestedMapAndListPropertyTest.assertNotNull((Object)map);
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.a", (Object)"foo", map.get("a"));
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.b", (Object)23, map.get("b"));
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.c", (Object)45L, map.get("c"));
        value = map.get("d");
        NestedMapAndListPropertyTest.assertTrue((String)"mapField.d should be a Map", (boolean)(value instanceof Map));
        map = (Map)value;
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.d.x", (Object)"abc", map.get("x"));
        value = map.get("y");
        NestedMapAndListPropertyTest.assertTrue((String)"mapField.d.y is a List", (boolean)(value instanceof List));
        List list = (List)value;
        LOG.debug("mapField.d.y: " + String.valueOf(list));
        NestedMapAndListPropertyTest.assertEquals((String)"listField.size", (int)3, (int)list.size());
        LOG.debug("Found map: " + String.valueOf(map));
        list = (List)message.getObjectProperty("listField");
        LOG.debug("listField: " + String.valueOf(list));
        NestedMapAndListPropertyTest.assertEquals((String)"listField.size", (int)3, (int)list.size());
        NestedMapAndListPropertyTest.assertEquals((String)"listField[0]", (Object)"a", list.get(0));
        NestedMapAndListPropertyTest.assertEquals((String)"listField[1]", (Object)"b", list.get(1));
        NestedMapAndListPropertyTest.assertEquals((String)"listField[2]", (Object)"c", list.get(2));
        NestedMapAndListPropertyTest.assertEquals((String)"JohnDoe", (String)message.getStringProperty("JMSXUserID"));
    }

    @Override
    protected Message createMessage(int index) throws JMSException {
        Message answer = this.session.createMessage();
        answer.setStringProperty("textField", this.data[index]);
        HashMap<String, Object> grandChildMap = new HashMap<String, Object>();
        grandChildMap.put("x", "abc");
        grandChildMap.put("y", Arrays.asList("a", "b", "c"));
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("a", "foo");
        nestedMap.put("b", 23);
        nestedMap.put("c", 45L);
        nestedMap.put("d", grandChildMap);
        answer.setObjectProperty("mapField", nestedMap);
        answer.setObjectProperty("listField", Arrays.asList("a", "b", "c"));
        answer.setStringProperty("JMSXUserID", "JohnDoe");
        return answer;
    }
}

