/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBDeleteLockTest {
    static final Logger LOG = LoggerFactory.getLogger(KahaDBDeleteLockTest.class);
    protected BrokerService master;
    protected KahaDBPersistenceAdapter masterPersistenceAdapter = new KahaDBPersistenceAdapter();
    private final File testDataDir = new File("target/activemq-data/KahaDBDeleteLockTest");
    private final File kahaDataDir = new File(this.testDataDir, "kahadb");

    @Before
    public void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.setDeleteAllMessagesOnStartup(true);
        this.master.setBrokerName("Master");
        this.master.setDataDirectoryFile(this.testDataDir);
        this.masterPersistenceAdapter.setDirectory(this.kahaDataDir);
        this.masterPersistenceAdapter.setLockKeepAlivePeriod(500L);
        File lockFile = new File(this.kahaDataDir, "lock");
        if (lockFile.exists()) {
            lockFile.delete();
        }
        this.master.setPersistenceAdapter((PersistenceAdapter)this.masterPersistenceAdapter);
        this.master.start();
        this.master.waitUntilStarted();
    }

    @After
    public void stopBrokerJustInCase() throws Exception {
        if (this.master != null) {
            this.master.stop();
            this.master.waitUntilStopped();
        }
    }

    @Test
    public void testLockFileDelete() throws Exception {
        Assert.assertTrue((boolean)this.master.isStarted());
        File lockFile = new File(this.kahaDataDir, "lock");
        if (lockFile.exists()) {
            lockFile.delete();
        }
        Assert.assertTrue((String)"Master stops on lock file delete", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return KahaDBDeleteLockTest.this.master.isStopped();
            }
        }));
    }

    @Test
    public void testModifyLockFile() throws Exception {
        Assert.assertTrue((boolean)this.master.isStarted());
        final File lockFile = new File(this.kahaDataDir, "lock");
        Assert.assertTrue((String)"lock file exists via modification time", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Lock file " + lockFile.getAbsolutePath() + ", last mod at: " + String.valueOf(new Date(lockFile.lastModified())));
                return lockFile.lastModified() > 0L;
            }
        }));
        TimeUnit.SECONDS.sleep(2L);
        RandomAccessFile file = new RandomAccessFile(lockFile, "rw");
        file.write(4);
        file.getChannel().force(true);
        file.close();
        Assert.assertTrue((String)"Master stops on lock file modification", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return KahaDBDeleteLockTest.this.master.isStopped();
            }
        }, (long)10000L));
    }
}

