/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.TempDestinationAuthorizationEntry;

public class AuthorizationMapTest
extends TestCase {
    static final GroupPrincipal USERS = new GroupPrincipal("users");
    static final GroupPrincipal ADMINS = new GroupPrincipal("admins");
    static final GroupPrincipal TEMP_DESTINATION_ADMINS = new GroupPrincipal("tempDestAdmins");

    public void testAuthorizationMap() {
        AuthorizationMap map = this.createAuthorizationMap();
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    public void testComposite() {
        AuthorizationMap map = this.createAuthorizationMap();
        this.addABEntry(map);
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR,DENIED"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(ADMINS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR,USERS.BAR.FOO"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("QUEUEA,QUEUEB"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    protected void addABEntry(AuthorizationMap map) {
        DefaultAuthorizationMap defaultMap = (DefaultAuthorizationMap)map;
        defaultMap.put((ActiveMQDestination)new ActiveMQQueue("QUEUEA"), (Object)this.createEntry("QUEUEA", "users", "users", "users"));
        defaultMap.put((ActiveMQDestination)new ActiveMQQueue("QUEUEB"), (Object)this.createEntry("QUEUEB", "users", "users", "users"));
    }

    public void testAuthorizationMapWithTempDest() {
        AuthorizationMap map = this.createAuthorizationMapWithTempDest();
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Set tempAdminACLs = map.getTempDestinationAdminACLs();
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(tempAdminACLs)), (int)1, (int)tempAdminACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)tempAdminACLs.contains(TEMP_DESTINATION_ADMINS));
    }

    public void testWildcards() {
        AuthorizationMap map = this.createWildcardAuthorizationMap();
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Set writeAcls = map.getWriteACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(writeAcls)), (int)1, (int)writeAcls.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)writeAcls.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)writeAcls.contains(USERS));
        Set adminAcls = map.getAdminACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(adminAcls)), (int)1, (int)adminAcls.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)adminAcls.contains(ADMINS));
        AuthorizationMapTest.assertFalse((String)"Contains users group", (boolean)adminAcls.contains(USERS));
        Set tempAdminACLs = map.getTempDestinationAdminACLs();
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(tempAdminACLs)), (int)1, (int)tempAdminACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)tempAdminACLs.contains(TEMP_DESTINATION_ADMINS));
    }

    public void testWildcardSubscriptions() {
        GroupPrincipal USERSA = new GroupPrincipal("usersA");
        DefaultAuthorizationMap map = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        entries.add(this.createEntry("A", "usersA", null, null));
        map.setAuthorizationEntries(entries);
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue(">"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)0, (int)readACLs.size());
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("A"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERSA));
        entries.add(this.createEntry("USERS.>", "users", null, null));
        map.setAuthorizationEntries(entries);
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue(">"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)0, (int)readACLs.size());
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("A"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERSA));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.TEST"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        entries.add(this.createEntry("USERS.A.>", "usersA", null, null));
        map.setAuthorizationEntries(entries);
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue(">"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)0, (int)readACLs.size());
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("A"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERSA));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.TEST"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.A.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERSA));
        entries.add(this.createEntry(">", "admins", null, null));
        map.setAuthorizationEntries(entries);
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue(">"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)1, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains admins group", (boolean)readACLs.contains(ADMINS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("A"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERSA));
        AuthorizationMapTest.assertTrue((String)"Contains admins group", (boolean)readACLs.contains(ADMINS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        AuthorizationMapTest.assertTrue((String)"Contains admins group", (boolean)readACLs.contains(ADMINS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains admins group", (boolean)readACLs.contains(ADMINS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.TEST"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        AuthorizationMapTest.assertTrue((String)"Contains admins group", (boolean)readACLs.contains(ADMINS));
        readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.A.>"));
        AuthorizationMapTest.assertEquals((String)("set size: " + String.valueOf(readACLs)), (int)3, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERSA));
        AuthorizationMapTest.assertTrue((String)"Contains admins group", (boolean)readACLs.contains(ADMINS));
    }

    protected AuthorizationMap createWildcardAuthorizationMap() {
        DefaultAuthorizationMap answer = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setQueue(">");
        try {
            entry.setRead("*");
            entry.setWrite("*");
            entry.setAdmin("admins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        answer.setAuthorizationEntries(entries);
        TempDestinationAuthorizationEntry tEntry = new TempDestinationAuthorizationEntry();
        try {
            tEntry.setAdmin("*");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        answer.setTempDestinationAuthorizationEntry(tEntry);
        return answer;
    }

    protected AuthorizationMap createAuthorizationMap() {
        DefaultAuthorizationMap answer = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setGroupClass("org.apache.activemq.jaas.GroupPrincipal");
        entry.setQueue(">");
        try {
            entry.setRead("admins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        entry = new AuthorizationEntry();
        entry.setQueue("USERS.>");
        try {
            entry.setRead("users");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        answer.setAuthorizationEntries(entries);
        return answer;
    }

    protected AuthorizationMap createAuthorizationMapWithTempDest() {
        DefaultAuthorizationMap answer = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setQueue(">");
        try {
            entry.setRead("admins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        entry = new AuthorizationEntry();
        entry.setQueue("USERS.>");
        try {
            entry.setRead("users");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        entries.add(entry);
        answer.setAuthorizationEntries(entries);
        TempDestinationAuthorizationEntry tEntry = new TempDestinationAuthorizationEntry();
        try {
            tEntry.setAdmin("tempDestAdmins");
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        answer.setTempDestinationAuthorizationEntry(tEntry);
        return answer;
    }

    protected AuthorizationEntry createEntry(String queue, String read, String write, String admin) {
        AuthorizationEntry entry = new AuthorizationEntry();
        if (queue != null) {
            entry.setQueue(queue);
        }
        try {
            if (read != null) {
                entry.setRead(read);
            }
            if (write != null) {
                entry.setWrite(write);
            }
            if (admin != null) {
                entry.setAdmin(admin);
            }
        }
        catch (Exception e) {
            AuthorizationMapTest.fail((String)e.toString());
        }
        return entry;
    }
}

