/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleTopicTest;
import org.apache.activemq.perf.SlowConsumer;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SlowConsumerTopicTest
extends SimpleTopicTest {
    protected PerfConsumer[] slowConsumers;

    @Override
    protected void setUp() throws Exception {
        this.playloadSize = 10240;
        super.setUp();
    }

    @Override
    protected PerfConsumer createConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        SlowConsumer result = new SlowConsumer(fac, dest);
        return result;
    }

    @Override
    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        PerfProducer result = super.createProducer(fac, dest, number, payload);
        result.setDeliveryMode(1);
        result.setSleep(10);
        return result;
    }

    @Override
    protected BrokerService createBroker(String url) throws Exception {
        ClassPathResource resource = new ClassPathResource("org/apache/activemq/perf/slowConsumerBroker.xml");
        System.err.println("CREATE BROKER FROM " + String.valueOf(resource));
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        broker.start();
        return broker;
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory(String uri) throws Exception {
        ActiveMQConnectionFactory result = super.createConnectionFactory(uri);
        ActiveMQPrefetchPolicy policy = new ActiveMQPrefetchPolicy();
        policy.setTopicPrefetch(10);
        result.setPrefetchPolicy(policy);
        return result;
    }
}

