/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jndi.ActiveMQInitialContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JNDITestSupport
extends TestCase {
    private static final Log LOG = LogFactory.getLog(JNDITestSupport.class);
    protected Hashtable<String, String> environment = new Hashtable();
    protected Context context;

    protected void assertConnectionFactoryPresent(String lookupName) throws NamingException {
        Object connectionFactory = this.context.lookup(lookupName);
        JNDITestSupport.assertTrue((String)("Should have created a ConnectionFactory for key: " + lookupName + " but got: " + String.valueOf(connectionFactory)), (boolean)(connectionFactory instanceof ConnectionFactory));
    }

    protected void assertBinding(Binding binding) throws NamingException {
        Object object = binding.getObject();
        JNDITestSupport.assertTrue((String)("Should have got a child context but got: " + String.valueOf(object)), (boolean)(object instanceof Context));
        Context childContext = (Context)object;
        NamingEnumeration<Binding> iter = childContext.listBindings("");
        while (iter.hasMore()) {
            Binding destinationBinding = iter.next();
            LOG.info((Object)("Found destination: " + destinationBinding.getName()));
            Object destination = destinationBinding.getObject();
            JNDITestSupport.assertTrue((String)("Should have a Destination but got: " + String.valueOf(destination)), (boolean)(destination instanceof Destination));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configureEnvironment();
        InitialContextFactory factory = this.getInitialContextFactory();
        this.context = factory.getInitialContext(this.environment);
        JNDITestSupport.assertTrue((String)"No context created", (this.context != null ? 1 : 0) != 0);
    }

    protected InitialContextFactory getInitialContextFactory() {
        return new ActiveMQInitialContextFactory();
    }

    protected void tearDown() throws NamingException, JMSException {
        NamingEnumeration<Binding> iter = this.context.listBindings("");
        while (iter.hasMore()) {
            Binding binding = iter.next();
            Object connFactory = binding.getObject();
            if (!(connFactory instanceof ActiveMQConnectionFactory)) continue;
        }
    }

    protected void configureEnvironment() {
        this.environment.put("brokerURL", "vm://localhost");
    }

    protected void assertDestinationExists(String name) throws NamingException {
        Object object = this.context.lookup(name);
        JNDITestSupport.assertTrue((String)("Should have received a Destination for name: " + name + " but instead found: " + String.valueOf(object)), (boolean)(object instanceof Destination));
    }
}

