/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.jndi.JNDITestSupport;

public class ActiveMQInitialContextFactoryTest
extends JNDITestSupport {
    public void testConnectionFactoriesArePresent() throws NamingException {
        String lookupName = this.getConnectionFactoryLookupName();
        this.assertConnectionFactoryPresent(lookupName);
    }

    public void testDestinationsArePresent() throws NamingException {
        InitialContext context = new InitialContext();
        ActiveMQInitialContextFactoryTest.assertTrue((String)"Created context", (context != null ? 1 : 0) != 0);
        Object topicDestination = context.lookup("MyTopic");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have found a topic but found: " + String.valueOf(topicDestination)), (boolean)(topicDestination instanceof ActiveMQTopic));
        Object queueDestination = context.lookup("MyQueue");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have found a queue but found: " + String.valueOf(queueDestination)), (boolean)(queueDestination instanceof ActiveMQQueue));
    }

    public void testDynamicallyGrowing() throws Exception {
        Object answer = this.context.lookup("dynamicQueues/FOO.BAR");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have found a queue but found: " + String.valueOf(answer)), (boolean)(answer instanceof ActiveMQQueue));
        ActiveMQQueue queue = (ActiveMQQueue)answer;
        ActiveMQInitialContextFactoryTest.assertEquals((String)"queue name", (String)"FOO.BAR", (String)queue.getPhysicalName());
        answer = this.context.lookup("dynamicTopics/A.B.C");
        ActiveMQInitialContextFactoryTest.assertTrue((String)("Should have found a topic but found: " + String.valueOf(answer)), (boolean)(answer instanceof ActiveMQTopic));
        ActiveMQTopic topic = (ActiveMQTopic)answer;
        ActiveMQInitialContextFactoryTest.assertEquals((String)"topic name", (String)"A.B.C", (String)topic.getPhysicalName());
    }

    protected String getConnectionFactoryLookupName() {
        return "ConnectionFactory";
    }
}

