/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jmx;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.util.JMXAuditLogEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.TestUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.Test;

public class JmxAuditLogTest
extends TestSupport {
    protected BrokerService broker;
    protected ActiveMQQueue queue;
    int portToUse;

    protected void setUp() throws Exception {
        super.setUp();
        this.setMaxTestTime(TimeUnit.MINUTES.toMillis(10L));
        this.setAutoFail(true);
        System.setProperty("org.apache.activemq.audit", "all");
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.portToUse = TestUtils.findOpenPort();
        this.broker.setManagementContext(this.createManagementContext("broker", this.portToUse));
        this.broker.setPopulateUserNameInMBeans(true);
        this.broker.setDestinations(this.createDestinations());
        TransportConnector transportConnector = this.broker.addConnector("tcp://0.0.0.0:0");
        transportConnector.setName("TCP");
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        System.clearProperty("org.apache.activemq.audit");
        this.broker.stop();
        super.tearDown();
    }

    protected ActiveMQDestination[] createDestinations() {
        this.queue = new ActiveMQQueue("myTestQueue");
        return new ActiveMQDestination[]{this.queue};
    }

    private MBeanServerConnection createJMXConnector(int port) throws Exception {
        String url = "service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi";
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"admin", "activemq"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(url), env);
        connector.connect();
        return connector.getMBeanServerConnection();
    }

    private ManagementContext createManagementContext(String name, int port) {
        ManagementContext managementContext = new ManagementContext();
        managementContext.setBrokerName(name);
        managementContext.setConnectorPort(port);
        managementContext.setConnectorHost("localhost");
        managementContext.setCreateConnector(true);
        HashMap<String, CallSite> env = new HashMap<String, CallSite>();
        env.put("jmx.remote.x.password.file", (CallSite)((Object)(String.valueOf(this.basedir) + "/src/test/resources/jmx.password")));
        env.put("jmx.remote.x.access.file", (CallSite)((Object)(String.valueOf(this.basedir) + "/src/test/resources/jmx.access")));
        managementContext.setEnvironment(env);
        return managementContext;
    }

    @Test
    public void testPasswordsAreNotLoggedWhenAuditIsTurnedOn() throws Exception {
        Logger log4jLogger = (Logger)LogManager.getLogger((String)"org.apache.activemq.audit");
        Configurator.setLevel((String)"org.apache.activemq.audit", (Level)Level.INFO);
        final AtomicInteger logCount = new AtomicInteger(0);
        final AtomicBoolean gotEnded = new AtomicBoolean(false);
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getMessage() != null) {
                    String message = event.getMessage().getFormattedMessage();
                    System.out.println(message);
                    if (message.contains("testPassword")) {
                        TestCase.fail((String)"Password should not appear in log file");
                    }
                    if (message.contains(JMXAuditLogEntry.VERBS[1])) {
                        gotEnded.set(true);
                    }
                }
                logCount.incrementAndGet();
            }
        };
        appender.start();
        log4jLogger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        log4jLogger.addAppender((Appender)appender);
        MBeanServerConnection conn = this.createJMXConnector(this.portToUse);
        ObjectName queueObjName = new ObjectName(String.valueOf(this.broker.getBrokerObjectName()) + ",destinationType=Queue,destinationName=" + this.queue.getQueueName());
        Object[] params = new Object[]{"body", "testUser", "testPassword"};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        conn.invoke(queueObjName, "sendTextMessage", params, signature);
        log4jLogger.removeAppender((Appender)appender);
        JmxAuditLogTest.assertTrue((String)"got ended statement", (boolean)gotEnded.get());
        JmxAuditLogTest.assertEquals((String)"got two messages", (int)2, (int)logCount.get());
    }

    @Test
    public void testNameTargetVisible() throws Exception {
        final AtomicInteger logCount = new AtomicInteger(0);
        final AtomicBoolean gotEnded = new AtomicBoolean(false);
        final AtomicBoolean gotQueueName = new AtomicBoolean(false);
        final AtomicBoolean gotBrokerName = new AtomicBoolean(false);
        final AtomicBoolean gotConnectorName = new AtomicBoolean(false);
        final String queueName = this.queue.getQueueName();
        Logger logger = (Logger)LogManager.getLogger((String)"org.apache.activemq.audit");
        Configurator.setLevel((String)"org.apache.activemq.audit", (Level)Level.INFO);
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getMessage() != null) {
                    String message = event.getMessage().getFormattedMessage();
                    System.out.println(message);
                    if (message.contains(JMXAuditLogEntry.VERBS[0])) {
                        if (message.contains(queueName)) {
                            gotQueueName.set(true);
                        }
                        if (message.contains(JmxAuditLogTest.this.broker.getBrokerName())) {
                            gotBrokerName.set(true);
                        }
                        if (message.contains("TCP")) {
                            gotConnectorName.set(true);
                        }
                    }
                    if (message.contains(JMXAuditLogEntry.VERBS[1])) {
                        gotEnded.set(true);
                    }
                }
                logCount.incrementAndGet();
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        MBeanServerConnection conn = this.createJMXConnector(this.portToUse);
        ObjectName queueObjName = new ObjectName(String.valueOf(this.broker.getBrokerObjectName()) + ",destinationType=Queue,destinationName=" + queueName);
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        conn.invoke(queueObjName, "purge", params, signature);
        JmxAuditLogTest.assertTrue((String)"got ended statement", (boolean)gotEnded.get());
        JmxAuditLogTest.assertEquals((String)"got two messages", (int)2, (int)logCount.get());
        JmxAuditLogTest.assertTrue((String)"got queueName in called statement", (boolean)gotQueueName.get());
        conn.invoke(this.broker.getBrokerObjectName(), "resetStatistics", params, signature);
        JmxAuditLogTest.assertEquals((String)"got 4 messages", (int)4, (int)logCount.get());
        JmxAuditLogTest.assertTrue((String)"got brokerName in called statement", (boolean)gotBrokerName.get());
        ObjectName transportConnectorON = BrokerMBeanSupport.createConnectorName((ObjectName)this.broker.getBrokerObjectName(), (String)"clientConnectors", (String)"TCP");
        conn.invoke(transportConnectorON, "stop", params, signature);
        JmxAuditLogTest.assertEquals((String)"got messages", (int)6, (int)logCount.get());
        JmxAuditLogTest.assertTrue((String)"got connectorName in called statement", (boolean)gotConnectorName.get());
        logger.removeAppender((Appender)appender);
    }
}

