/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.ActiveMQMessageProducerSupport;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQJMS2ProducerTest
extends ActiveMQJMS2TestBase {
    private static final String PROPERTY_NAME_VALID = "ValidName";
    private static final String PROPERTY_VALUE_VALID = "valid value";
    private static final Set<String> PROPERTY_NAMES_INVALID = Set.of("contains+plus+sign", "123startswithnumber", "contains blank space", "has-dash", "with&amp");
    private static final Set<Object> PROPERTY_VALUES_INVALID = Set.of(new HashSet(), new HashMap(), ZonedDateTime.now());

    @Test
    public void testInvalidPropertyNameNullEmpty() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            JMSProducer jmsProducer = jmsContext.createProducer();
            jmsContext.start();
            boolean caught = false;
            try {
                jmsProducer.setProperty(null, PROPERTY_VALUE_VALID);
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"Invalid JMS property name must not be null or empty", (Object)e.getMessage());
                caught = true;
            }
            Assert.assertTrue((boolean)caught);
            caught = false;
            try {
                jmsProducer.setProperty("", PROPERTY_VALUE_VALID);
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"Invalid JMS property name must not be null or empty", (Object)e.getMessage());
                caught = true;
            }
            Assert.assertTrue((boolean)caught);
            boolean bl = false;
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInvalidPropertyNameKeyword() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            JMSProducer jmsProducer = jmsContext.createProducer();
            jmsContext.start();
            for (String propertyName : ActiveMQMessageProducerSupport.JMS_PROPERTY_NAMES_DISALLOWED) {
                boolean caught = false;
                try {
                    jmsProducer.setProperty(propertyName, PROPERTY_VALUE_VALID);
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)("Invalid JMS property: " + propertyName + " name is in disallowed list"), (Object)e.getMessage());
                    caught = true;
                }
                Assert.assertTrue((String)("Expected exception for propertyName: " + propertyName), (boolean)caught);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInvalidPropertyNameInvalidJavaIdentifier() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            JMSProducer jmsProducer = jmsContext.createProducer();
            jmsContext.start();
            for (String propertyName : PROPERTY_NAMES_INVALID) {
                boolean caught = false;
                try {
                    jmsProducer.setProperty(propertyName, PROPERTY_VALUE_VALID);
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid JMS property: " + propertyName + " name"));
                    Assert.assertTrue((boolean)e.getMessage().contains("invalid character"));
                    caught = true;
                }
                Assert.assertTrue((String)("Expected exception for propertyName: " + propertyName), (boolean)caught);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInvalidPropertyNameInvalidValueClassType() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            JMSProducer jmsProducer = jmsContext.createProducer();
            jmsContext.start();
            for (Object propertyValue : PROPERTY_VALUES_INVALID) {
                boolean caught = false;
                try {
                    jmsProducer.setProperty(PROPERTY_NAME_VALID, propertyValue);
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)("Invalid JMS property: ValidName value class: " + propertyValue.getClass().getName() + " is not permitted by specification"), (Object)e.getMessage());
                    caught = true;
                }
                Assert.assertTrue((String)("Expected exception for propertyValue: " + String.valueOf(propertyValue)), (boolean)caught);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDisableTimestamp() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            JMSProducer jmsProducer1 = jmsContext.createProducer();
            jmsProducer1.setDisableMessageTimestamp(true);
            jmsContext.start();
            String textBody = "Test-" + this.methodNameDestinationName;
            jmsProducer1.send((Destination)destination, textBody);
            ActiveMQJMS2ProducerTest.verifyTimestamp(jmsContext, (Destination)destination, textBody, true);
            jmsProducer1.setDisableMessageTimestamp(false);
            jmsProducer1.send((Destination)destination, textBody);
            ActiveMQJMS2ProducerTest.verifyTimestamp(jmsContext, (Destination)destination, textBody, false);
            JMSProducer jmsProducer2 = jmsContext.createProducer();
            jmsProducer2.setDisableMessageTimestamp(true);
            jmsProducer2.send((Destination)destination, textBody);
            ActiveMQJMS2ProducerTest.verifyTimestamp(jmsContext, (Destination)destination, textBody, true);
            jmsProducer1.send((Destination)destination, textBody);
            ActiveMQJMS2ProducerTest.verifyTimestamp(jmsContext, (Destination)destination, textBody, false);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected static void verifyTimestamp(JMSContext jmsContext, Destination destination, String expectedTextBody, boolean expectTimestampZero) throws JMSException {
        try (JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);){
            Message message = jmsConsumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
            if (expectTimestampZero) {
                Assert.assertEquals((Object)0L, (Object)message.getJMSTimestamp());
            } else {
                Assert.assertNotEquals((Object)0L, (Object)message.getJMSTimestamp());
            }
        }
    }
}

