/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Enumeration;
import org.apache.activemq.ActiveMQContext;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQJMS2ContextTest
extends ActiveMQJMS2TestBase {
    @Test
    public void testConnectionFactoryCreateContext() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextSession() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext(1);){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextUserPass() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin");){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextUserPassSession() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionFactoryCreateContexMultiContext() {
        JMSContext secondJMSContext = null;
        JMSContext thirdJMSContext = null;
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin");){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue testDestination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)testDestination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessage(jmsContext, (Destination)testDestination, "Test-" + this.methodNameDestinationName);
            secondJMSContext = jmsContext.createContext(1);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
        String secondTestDestinationName = this.methodNameDestinationName + ".SECOND";
        Queue secondTestDestination = secondJMSContext.createQueue(secondTestDestinationName);
        try {
            ActiveMQJMS2ContextTest.sendMessage(secondJMSContext, (Destination)secondTestDestination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessage(secondJMSContext, (Destination)secondTestDestination, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (secondJMSContext != null) {
                try {
                    secondJMSContext.close();
                }
                catch (JMSRuntimeException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        boolean caught = false;
        try {
            thirdJMSContext = secondJMSContext.createContext(1);
            Assert.fail((String)"JMSRuntimeException expected");
        }
        catch (JMSRuntimeException e) {
            Assert.assertNull((Object)thirdJMSContext);
            caught = true;
            Assert.assertEquals((Object)"Context already closed", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caught);
    }

    @Test
    public void testConnectionFactoryCreateContextBrowse() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.browseMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName, true);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextBrowseAutoStart() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.browseMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName, true);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextBrowseAutoStartFalse() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setAutoStart(false);
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.browseMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName, false);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionFactoryCreateContextBrowseAutoStartFalseStartDelayed() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setAutoStart(false);
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName);
            jmsContext.start();
            ActiveMQJMS2ContextTest.browseMessage(jmsContext, (Destination)destination, "Test-" + this.methodNameDestinationName, true);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDisableMessageID() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setAutoStart(false);
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            jmsContext.start();
            JMSProducer jmsProducer = jmsContext.createProducer();
            jmsProducer.setDisableMessageID(true);
            Queue destination = jmsContext.createQueue(this.methodNameDestinationName);
            TextMessage sendMessage = jmsContext.createTextMessage("Test-" + this.methodNameDestinationName);
            jmsProducer.send((Destination)destination, (Message)sendMessage);
            JMSConsumer jmsConsumer = jmsContext.createConsumer((Destination)destination);
            Message recvMessage = jmsConsumer.receive(5000L);
            Assert.assertNotNull((Object)recvMessage);
            Assert.assertEquals((Object)sendMessage.getJMSMessageID(), (Object)recvMessage.getJMSMessageID());
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testConnectionSharedConnectionConsumer() throws JMSException {
        this.connection.createSharedConnectionConsumer(null, null, null, null, 10);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testConnectionSharedDurableConnectionConsumer() throws JMSException {
        this.connection.createSharedDurableConnectionConsumer(null, null, null, null, 10);
    }

    @Test
    public void testSessionDurableConsumer() throws JMSException {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setAutoStart(false);
            jmsContext.setClientID(this.testName.getMethodName());
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Topic topic = jmsContext.createTopic(this.methodNameDestinationName);
            JMSConsumer jmsConsumerRegisterDurableConsumer = jmsContext.createDurableConsumer(topic, this.testName.getMethodName());
            jmsConsumerRegisterDurableConsumer.close();
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)topic, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessageDurable(jmsContext, topic, this.testName.getMethodName(), null, false, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSessionDurableConsumerSelectorNoLocal() throws JMSException {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext();){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setAutoStart(false);
            jmsContext.setClientID(this.testName.getMethodName());
            jmsContext.start();
            Assert.assertTrue((boolean)ActiveMQContext.class.isAssignableFrom(jmsContext.getClass()));
            Topic topic = jmsContext.createTopic(this.methodNameDestinationName);
            JMSConsumer jmsConsumerRegisterDurableConsumer = jmsContext.createDurableConsumer(topic, this.testName.getMethodName(), "TRUE", false);
            jmsConsumerRegisterDurableConsumer.close();
            ActiveMQJMS2ContextTest.sendMessage(jmsContext, (Destination)topic, "Test-" + this.methodNameDestinationName);
            ActiveMQJMS2ContextTest.recvMessageDurable(jmsContext, topic, this.testName.getMethodName(), "TRUE", false, "Test-" + this.methodNameDestinationName);
        }
        catch (JMSException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSessionSharedConsumer() throws JMSException {
        this.session.createSharedConsumer(null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSessionSharedConsumerSelector() throws JMSException {
        this.session.createSharedConsumer(null, null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSessionSharedDurableConsumer() throws JMSException {
        this.session.createSharedDurableConsumer(null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSessionSharedDurableConsumerSelector() throws JMSException {
        this.session.createSharedDurableConsumer(null, null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProducerDeliveryDelayGet() throws JMSException {
        this.messageProducer.getDeliveryDelay();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProducerDeliveryDelaySet() throws JMSException {
        this.messageProducer.setDeliveryDelay(1000L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProducerSendMessageCompletionListener() throws JMSException {
        this.messageProducer.send((Destination)this.session.createQueue(this.methodNameDestinationName), null, (CompletionListener)null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProducerSendMessageQoSParamsCompletionListener() throws JMSException {
        this.messageProducer.send(null, 1, 4, 0L, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProducerSendDestinationMessageCompletionListener() throws JMSException {
        this.messageProducer.send((Destination)this.session.createQueue(this.methodNameDestinationName), null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProducerSendDestinationMessageQosParamsCompletionListener() throws JMSException {
        this.messageProducer.send((Destination)this.session.createQueue(this.methodNameDestinationName), null, 1, 4, 0L, null);
    }

    protected static void sendMessage(JMSContext jmsContext, Destination testDestination, String textBody) {
        Assert.assertNotNull((Object)jmsContext);
        JMSProducer jmsProducer = jmsContext.createProducer();
        jmsProducer.send(testDestination, textBody);
    }

    protected static void browseMessage(JMSContext jmsContext, Destination testDestination, String expectedTextBody, boolean expectFound) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        Assert.assertTrue((boolean)Queue.class.isAssignableFrom(testDestination.getClass()));
        Queue testQueue = (Queue)Queue.class.cast(testDestination);
        try (QueueBrowser queueBrowser = jmsContext.createBrowser(testQueue);){
            Enumeration messageEnumeration = queueBrowser.getEnumeration();
            Assert.assertNotNull((Object)messageEnumeration);
            boolean found = false;
            while (!found && messageEnumeration.hasMoreElements()) {
                Message message = (Message)messageEnumeration.nextElement();
                Assert.assertNotNull((Object)message);
                Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
                Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
                found = true;
            }
            Assert.assertEquals((Object)expectFound, (Object)found);
        }
    }

    protected static void recvMessage(JMSContext jmsContext, Destination testDestination, String expectedTextBody) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        try (JMSConsumer jmsConsumer = jmsContext.createConsumer(testDestination);){
            Message message = jmsConsumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
        }
    }

    protected static void recvMessageDurable(JMSContext jmsContext, Topic testTopic, String subscriptionName, String selector, boolean noLocal, String expectedTextBody) throws JMSException {
        Assert.assertNotNull((Object)jmsContext);
        try (JMSConsumer jmsConsumer = jmsContext.createDurableConsumer(testTopic, subscriptionName, selector, noLocal);){
            Message message = jmsConsumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)expectedTextBody, (Object)((TextMessage)TextMessage.class.cast(message)).getText());
        }
    }
}

