/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5893Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ5893Test.class);
    private final int MSG_COUNT = 20;
    private BrokerService brokerService;
    private Connection connection;
    private String brokerURI;
    private CountDownLatch done;
    @Rule
    public TestName name = new TestName();

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(true);
        this.brokerService.getManagementContext().setCreateConnector(false);
        this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.brokerURI = "failover:" + this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString();
    }

    @After
    public void stopBroker() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Test(timeout=60000L)
    public void tesIndividualAcksWithClosedConsumerAndAuditAsync() throws Exception {
        this.produceSomeMessages(20);
        QueueViewMBean queueView = this.getProxyToQueue(this.getDestinationName());
        Assert.assertEquals((long)20L, (long)queueView.getQueueSize());
        this.connection = this.createConnection();
        Session session = this.connection.createSession(false, 4);
        Queue queue = session.createQueue(this.getDestinationName());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        this.connection.start();
        this.done = new CountDownLatch(20);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.debug("Received message: {}", (Object)message);
                AMQ5893Test.this.done.countDown();
            }
        });
        this.done.await(15L, TimeUnit.SECONDS);
        consumer.close();
        Assert.assertEquals((long)20L, (long)queueView.getQueueSize());
        consumer = session.createConsumer((Destination)queue);
        this.done = new CountDownLatch(20);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.debug("Received message: {}", (Object)message);
                AMQ5893Test.this.done.countDown();
            }
        });
        this.done.await(15L, TimeUnit.SECONDS);
        consumer.close();
        Assert.assertEquals((long)20L, (long)queueView.getQueueSize());
    }

    @Test(timeout=60000L)
    public void tesIndividualAcksWithClosedConsumerAndAuditSync() throws Exception {
        Message message;
        int i;
        this.produceSomeMessages(20);
        QueueViewMBean queueView = this.getProxyToQueue(this.getDestinationName());
        Assert.assertEquals((long)20L, (long)queueView.getQueueSize());
        this.connection = this.createConnection();
        Session session = this.connection.createSession(false, 4);
        Queue queue = session.createQueue(this.getDestinationName());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        this.connection.start();
        for (i = 0; i < 20; ++i) {
            message = consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            LOG.debug("Received message: {}", (Object)message);
        }
        consumer.close();
        Assert.assertEquals((long)20L, (long)queueView.getQueueSize());
        consumer = session.createConsumer((Destination)queue);
        for (i = 0; i < 20; ++i) {
            message = consumer.receive(1000L);
            Assert.assertNotNull((Object)message);
            LOG.debug("Received message: {}", (Object)message);
        }
        consumer.close();
        Assert.assertEquals((long)20L, (long)queueView.getQueueSize());
    }

    private QueueViewMBean getProxyToQueue(String name) throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + name);
        QueueViewMBean proxy = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    private void produceSomeMessages(int count) throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 4);
        Queue queue = session.createQueue(this.getDestinationName());
        MessageProducer producer = session.createProducer((Destination)queue);
        for (int i = 0; i < count; ++i) {
            Message message = session.createMessage();
            producer.send(message);
        }
        connection.close();
    }

    private Connection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        Connection connection = factory.createConnection();
        return connection;
    }

    private String getDestinationName() {
        return this.name.getMethodName() + "-Queue";
    }
}

