/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.TransactionBroker;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.transaction.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4485Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4485Test.class);
    BrokerService broker;
    ActiveMQConnectionFactory factory;
    final int messageCount = 20;
    int memoryLimit = 40960;
    final ActiveMQQueue destination = new ActiveMQQueue("QUEUE." + ((Object)((Object)this)).getClass().getName());
    final Vector<Throwable> exceptions = new Vector();
    final CountDownLatch slowSendResume = new CountDownLatch(1);

    protected void configureBroker(long memoryLimit) throws Exception {
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setAdvisorySupport(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(0L);
        policy.setMemoryLimit(memoryLimit);
        policy.setProducerFlowControl(false);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void send(ProducerBrokerExchange producerExchange, final org.apache.activemq.command.Message messageSend) throws Exception {
                if (messageSend.isInTransaction() && messageSend.getProperty("NUM") != null) {
                    final Integer num = (Integer)messageSend.getProperty("NUM");
                    TransactionBroker transactionBroker = (TransactionBroker)AMQ4485Test.this.broker.getBroker().getAdaptor(TransactionBroker.class);
                    transactionBroker.getTransaction(producerExchange.getConnectionContext(), messageSend.getTransactionId(), false).addSynchronization(new Synchronization(){

                        public void afterCommit() throws Exception {
                            LOG.error("AfterCommit, NUM:" + num + ", " + String.valueOf(messageSend.getMessageId()) + ", tx: " + String.valueOf(messageSend.getTransactionId()));
                            if (num == 5) {
                                LOG.error("Pausing on latch in afterCommit for: " + num + ", " + String.valueOf(messageSend.getMessageId()));
                                AMQ4485Test.this.slowSendResume.await(20L, TimeUnit.SECONDS);
                                LOG.error("resuming on latch afterCommit for: " + num + ", " + String.valueOf(messageSend.getMessageId()));
                            } else if (21 == num) {
                                LOG.error("releasing latch. " + num + ", " + String.valueOf(messageSend.getMessageId()));
                                AMQ4485Test.this.slowSendResume.countDown();
                                TimeUnit.SECONDS.sleep(5L);
                                LOG.error("resuming afterCommit for: " + num + ", " + String.valueOf(messageSend.getMessageId()));
                            }
                        }
                    });
                }
                super.send(producerExchange, messageSend);
            }
        }});
    }

    public void testOutOfOrderTransactionCompletionOnMemoryLimit() throws Exception {
        int i;
        HashSet<Integer> expected = new HashSet<Integer>();
        final Vector<Session> sessionVector = new Vector<Session>();
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (i = 1; i <= 20; ++i) {
            sessionVector.add(this.send(i, 1, true));
            expected.add(i);
        }
        i = 0;
        while (i < 20) {
            final int id = i++;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((Session)sessionVector.get(id)).commit();
                    }
                    catch (Exception fail) {
                        AMQ4485Test.this.exceptions.add(fail);
                    }
                }
            });
        }
        DestinationViewMBean queueViewMBean = (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(this.broker.getAdminView().getQueues()[0], DestinationViewMBean.class, false);
        TimeUnit.SECONDS.sleep(3L);
        LOG.info("Big send to blow available destination usage before slow send resumes");
        this.send(21, 35840, true).commit();
        Connection cosumerConnection = this.factory.createConnection();
        cosumerConnection.start();
        MessageConsumer consumer = cosumerConnection.createSession(false, 1).createConsumer((Destination)this.destination);
        for (int i2 = 1; i2 <= 21; ++i2) {
            BytesMessage bytesMessage = (BytesMessage)consumer.receive(10000L);
            AMQ4485Test.assertNotNull((String)("Got message: " + i2 + ", " + String.valueOf(expected)), (Object)bytesMessage);
            MessageId mqMessageId = ((ActiveMQBytesMessage)bytesMessage).getMessageId();
            LOG.info("got: " + String.valueOf(expected) + ", " + String.valueOf(mqMessageId) + ", NUM=" + String.valueOf(((ActiveMQBytesMessage)bytesMessage).getProperty("NUM")));
            expected.remove(((ActiveMQBytesMessage)bytesMessage).getProperty("NUM"));
        }
    }

    private Session send(int id, int messageSize, boolean transacted) throws Exception {
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(transacted, transacted ? 0 : 1);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(new byte[messageSize]);
        bytesMessage.setIntProperty("NUM", id);
        producer.send((Message)bytesMessage);
        LOG.info("Sent:" + bytesMessage.getJMSMessageID() + " session tx: " + String.valueOf(((ActiveMQBytesMessage)bytesMessage).getTransactionId()));
        return session;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.setBrokerName("thisOne");
        this.configureBroker(this.memoryLimit);
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory("vm://thisOne?jms.alwaysSyncSend=true");
        this.factory.setWatchTopicAdvisories(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }
}

