/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.net.URI;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2439Test
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2439Test.class);
    Destination dest;

    public void testDuplicatesThroughNetwork() throws Exception {
        AMQ2439Test.assertEquals((String)"received expected amount", (int)500, (int)this.receiveExactMessages("BrokerB", 500));
        AMQ2439Test.assertEquals((String)"received expected amount", (int)500, (int)this.receiveExactMessages("BrokerB", 500));
        this.validateQueueStats();
    }

    private void validateQueueStats() throws Exception {
        final BrokerView brokerView = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker.getAdminView();
        AMQ2439Test.assertEquals((String)"enequeue is correct", (long)1000L, (long)brokerView.getTotalEnqueueCount());
        AMQ2439Test.assertTrue((String)"dequeue is correct", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("dequeue count (want 1000), is : " + brokerView.getTotalDequeueCount());
                return 1000L == brokerView.getTotalDequeueCount();
            }
        }));
    }

    protected int receiveExactMessages(String brokerName, int msgCount) throws Exception {
        Message msg;
        int i;
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(brokerName);
        Connection connection = brokerItem.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer(this.dest);
        for (i = 0; i < msgCount && (msg = consumer.receive(1000L)) != null; ++i) {
        }
        connection.close();
        brokerItem.connections.remove(connection);
        return i;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=true&deleteAllMessagesOnStartup=true&advisorySupport=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=true&deleteAllMessagesOnStartup=true&useJmx=false"));
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.startAllBrokers();
        this.dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("BrokerA", this.dest, 1000);
    }
}

