/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class AMQ2174Test {
    @Rule
    public TestName testName = new TestName();
    private BrokerService broker;
    private ActiveMQConnectionFactory cf;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.setUseJmx(false);
        this.broker.start();
        this.broker.waitUntilStarted();
        String connectionURI = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
        this.cf = new ActiveMQConnectionFactory(connectionURI);
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    @Test(timeout=60000L)
    public void testChangeDurableSub() throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID(this.testName.getMethodName());
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic(this.testName.getMethodName());
        TopicSubscriber consumer = session.createDurableSubscriber(destination, this.testName.getMethodName(), "color = 'red'", false);
        consumer.close();
        this.sendMessages();
        consumer = session.createDurableSubscriber(destination, this.testName.getMethodName(), "color = 'red'", false);
        Message received = consumer.receive(2000L);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"red", (Object)received.getStringProperty("color"));
        Assert.assertNull((Object)consumer.receive(10L));
        consumer.close();
        this.sendMessages();
        consumer = session.createDurableSubscriber(destination, this.testName.getMethodName(), "color = 'green'", false);
        received = consumer.receive(500L);
        Assert.assertNull((Object)received);
        this.sendMessages();
        received = consumer.receive(2000L);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"green", (Object)received.getStringProperty("color"));
        Assert.assertNull((Object)consumer.receive(10L));
        consumer.close();
        consumer = session.createDurableSubscriber(destination, this.testName.getMethodName());
        this.sendMessages();
        received = consumer.receive(2000L);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"red", (Object)received.getStringProperty("color"));
        received = consumer.receive(2000L);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"green", (Object)received.getStringProperty("color"));
        received = consumer.receive(2000L);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)"blue", (Object)received.getStringProperty("color"));
        Assert.assertNull((Object)consumer.receive(10L));
        consumer.close();
    }

    private void sendMessages() throws Exception {
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic(this.testName.getMethodName());
        MessageProducer producer = session.createProducer((Destination)destination);
        Message message1 = session.createMessage();
        Message message2 = session.createMessage();
        Message message3 = session.createMessage();
        message1.setStringProperty("color", "red");
        message2.setStringProperty("color", "green");
        message3.setStringProperty("color", "blue");
        producer.send(message1);
        producer.send(message2);
        producer.send(message3);
        connection.close();
    }
}

