/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.IOException;
import java.net.URI;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.xbean.XBeanBrokerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationInterceptorDurableSubTest
extends EmbeddedBrokerTestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(DestinationInterceptorDurableSubTest.class);
    private MBeanServerConnection mbsc = null;
    public static final String JMX_CONTEXT_BASE_NAME = "org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Topic,destinationName=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVirtualTopicRemoval() throws Exception {
        LOG.debug("Running testVirtualTopicRemoval()");
        String clientId1 = "myId1";
        String clientId2 = "myId2";
        Connection conn = null;
        Session session = null;
        try {
            DestinationInterceptorDurableSubTest.assertTrue((boolean)this.broker.isStarted());
            conn = this.createConnection();
            conn.setClientID(clientId1);
            conn.start();
            session = conn.createSession(false, 1);
            TopicSubscriber sub1 = session.createDurableSubscriber((Topic)this.destination, clientId1);
            TopicSubscriber sub2 = session.createDurableSubscriber((Topic)this.destination, clientId2);
            this.assertSubscriptionCount(this.destination.getPhysicalName(), 2);
            DestinationInterceptorDurableSubTest.assertTrue((boolean)this.isSubRegisteredInJmx(this.destination.getPhysicalName(), clientId1));
            DestinationInterceptorDurableSubTest.assertTrue((boolean)this.isSubRegisteredInJmx(this.destination.getPhysicalName(), clientId2));
            sub1.close();
            session.unsubscribe(clientId1);
            this.assertSubscriptionCount(this.destination.getPhysicalName(), 1);
            DestinationInterceptorDurableSubTest.assertFalse((boolean)this.isSubRegisteredInJmx(this.destination.getPhysicalName(), clientId1));
            DestinationInterceptorDurableSubTest.assertTrue((boolean)this.isSubRegisteredInJmx(this.destination.getPhysicalName(), clientId2));
            sub2.close();
            session.unsubscribe(clientId2);
            this.assertSubscriptionCount(this.destination.getPhysicalName(), 0);
            DestinationInterceptorDurableSubTest.assertFalse((boolean)this.isSubRegisteredInJmx(this.destination.getPhysicalName(), clientId1));
            DestinationInterceptorDurableSubTest.assertFalse((boolean)this.isSubRegisteredInJmx(this.destination.getPhysicalName(), clientId2));
        }
        finally {
            session.close();
            conn.close();
        }
    }

    protected MBeanServerConnection connectJMXBroker() throws IOException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:1299/jmxrmi");
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
        LOG.debug("JMX connection established");
        return mbsc;
    }

    protected boolean assertSubscriptionCount(String topicName, int expectedCount) {
        try {
            if (this.mbsc == null) {
                this.mbsc = this.connectJMXBroker();
            }
            ObjectName[] tmp = (ObjectName[])this.mbsc.getAttribute(new ObjectName(JMX_CONTEXT_BASE_NAME + topicName), "Subscriptions");
            DestinationInterceptorDurableSubTest.assertEquals((int)expectedCount, (int)tmp.length);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean isSubRegisteredInJmx(String topicName, String subName) {
        try {
            if (this.mbsc == null) {
                this.mbsc = this.connectJMXBroker();
            }
            ObjectName[] names = (ObjectName[])this.mbsc.getAttribute(new ObjectName(JMX_CONTEXT_BASE_NAME + topicName), "Subscriptions");
            ObjectInstance instance = this.mbsc.getObjectInstance(new ObjectName(JMX_CONTEXT_BASE_NAME + topicName + ",endpoint=Consumer,clientId=myId1,consumerId=Durable(myId1_" + subName + ")"));
            if (instance == null) {
                return false;
            }
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].toString().contains(subName)) continue;
                return true;
            }
        }
        catch (InstanceNotFoundException ine) {
            LOG.info(ine.toString());
            return false;
        }
        catch (Exception ex) {
            LOG.error(ex.toString());
            return false;
        }
        return false;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        XBeanBrokerFactory factory = new XBeanBrokerFactory();
        BrokerService answer = factory.createBroker(new URI(this.getBrokerConfigUri()));
        answer.setPersistent(false);
        this.useTopic = true;
        return answer;
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/virtual/virtual-topics-and-interceptor.xml";
    }

    public static class SimpleDestinationInterceptor
    implements DestinationInterceptor {
        private final Logger LOG = LoggerFactory.getLogger(SimpleDestinationInterceptor.class);
        private BrokerService broker;

        public void setBrokerService(BrokerService brokerService) {
            this.LOG.info("setBrokerService()");
            this.broker = brokerService;
        }

        public Destination intercept(Destination destination) {
            this.LOG.info("intercept({})", (Object)destination.getName());
            if (!destination.getActiveMQDestination().getPhysicalName().startsWith("ActiveMQ")) {
                return new DestinationFilter(destination){

                    public void send(ProducerBrokerExchange context, Message message) throws Exception {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SimpleDestinationInterceptor: Sending message to destination:" + this.getActiveMQDestination().getPhysicalName());
                        }
                        super.send(context, message);
                    }
                };
            }
            return destination;
        }

        public void remove(Destination destination) {
            this.LOG.info("remove({})", (Object)destination.getName());
            this.broker = null;
        }

        public void create(Broker broker, ConnectionContext context, ActiveMQDestination destination) throws Exception {
            this.LOG.info("create(" + broker.getBrokerName() + ", " + context.toString() + ", " + destination.getPhysicalName());
        }
    }
}

