/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AMQ9685Test {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private BrokerService brokerService;
    private Connection connection;
    private String dir;
    private ActiveMQQueue destination = new ActiveMQQueue("Consumer.foo.");

    @Before
    public void init() throws Exception {
        this.dir = this.temp.newFolder().getAbsolutePath();
        this.brokerService = this.createBroker();
        this.brokerService.start();
        this.connection = new ActiveMQConnectionFactory(this.brokerService.getVmConnectorURI()).createConnection();
        this.connection.start();
    }

    @After
    public void after() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.brokerService.stop();
    }

    @Test
    public void testVirtualTopicMissingNameManual() throws Exception {
        this.brokerService.getRegionBroker().addDestination(this.brokerService.getAdminConnectionContext(), (ActiveMQDestination)this.destination, false);
        Assert.assertTrue((boolean)this.brokerService.getBroker().getDestinationMap().containsKey(this.destination));
        Assert.assertTrue((boolean)this.brokerService.getPersistenceAdapter().getDestinations().contains(this.destination));
        this.restart();
    }

    @Test
    public void testVirtualTopicMissingNameConsumer() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createConsumer((Destination)this.destination, null);
        Assert.assertTrue((boolean)this.brokerService.getBroker().getDestinationMap().containsKey(this.destination));
        Assert.assertTrue((boolean)this.brokerService.getPersistenceAdapter().getDestinations().contains(this.destination));
        this.restart();
    }

    private BrokerService createBroker() {
        BrokerService broker = new BrokerService();
        broker.setAdvisorySupport(false);
        broker.setPersistent(true);
        broker.setDataDirectory(this.dir);
        VirtualTopic virtualTopic = new VirtualTopic();
        VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
        interceptor.setVirtualDestinations(new VirtualDestination[]{virtualTopic});
        broker.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
        return broker;
    }

    private void restart() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        this.brokerService = this.createBroker();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }
}

