/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import junit.framework.TestCase;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ErrorBroker;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.broker.util.RedeliveryPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryPluginTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryPluginTest.class);
    RedeliveryPlugin underTest = new RedeliveryPlugin();

    public void testInstallPluginValidation() throws Exception {
        RedeliveryPolicyMap redeliveryPolicyMap = new RedeliveryPolicyMap();
        RedeliveryPolicy defaultEntry = new RedeliveryPolicy();
        defaultEntry.setInitialRedeliveryDelay(500L);
        redeliveryPolicyMap.setDefaultEntry(defaultEntry);
        this.underTest.setRedeliveryPolicyMap(redeliveryPolicyMap);
        final BrokerService brokerService = new BrokerService();
        brokerService.setSchedulerSupport(false);
        ErrorBroker broker = new ErrorBroker("hi"){

            public BrokerService getBrokerService() {
                return brokerService;
            }
        };
        try {
            this.underTest.installPlugin((Broker)broker);
            RedeliveryPluginTest.fail((String)"expect exception on no scheduler support");
        }
        catch (Exception expected) {
            LOG.info("expected: " + String.valueOf(expected));
        }
        brokerService.setSchedulerSupport(true);
        try {
            this.underTest.installPlugin((Broker)broker);
            RedeliveryPluginTest.fail((String)"expect exception on small initial delay");
        }
        catch (Exception expected) {
            LOG.info("expected: " + String.valueOf(expected));
        }
        defaultEntry.setInitialRedeliveryDelay(5000L);
        defaultEntry.setRedeliveryDelay(500L);
        brokerService.setSchedulerSupport(true);
        try {
            this.underTest.installPlugin((Broker)broker);
            RedeliveryPluginTest.fail((String)"expect exception on small redelivery delay");
        }
        catch (Exception expected) {
            LOG.info("expected: " + String.valueOf(expected));
        }
    }
}

